/*
 * Decompiled with CFR 0.152.
 */
package model.components.schedulers;

import model.components.schedulers.Scheduler;
import model.experiment.ExperimentSimplePiston;
import settings.Settings;
import visualization.gui.components.MainStageController;

public class StageScheduler
extends Scheduler<ExperimentSimplePiston> {
    private final String stage;
    private final int firstStepID;
    private final int lastStepId;
    public double timeStop;

    public StageScheduler(String stageIn, double timeStart, double timeStop, MainStageController overlordIn) {
        this.type = "Stage";
        this.stage = stageIn;
        this.timeStop = timeStop;
        this.time = timeStart;
        this.overlord = overlordIn;
        this.firstStepID = (int)(timeStart / Settings.totalTime * (double)Settings.numberOfTimeSteps);
        this.lastStepId = (int)(timeStop / Settings.totalTime * (double)Settings.numberOfTimeSteps);
    }

    public String toString() {
        return this.stage;
    }

    public double getTimeStop() {
        return this.timeStop;
    }

    @Override
    public void update(double timeIn) {
        int stepID = (int)timeIn;
        if (stepID < this.lastStepId && stepID >= this.firstStepID) {
            this.isActive = true;
            this.hasFired = true;
        } else {
            this.isActive = false;
        }
        if (stepID == this.firstStepID) {
            this.overlord.getExperiment().stage = this.stage;
            this.overlord.getExperiment().getRecorder().workCurrent = 0.0;
            this.overlord.getExperiment().getRecorder().heatCurrent = 0.0;
        }
    }
}

