/*
 * Decompiled with CFR 0.152.
 */
package model.components.particleEmitters;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import model.components.basic.Particle;
import model.components.core.VTLComponent;
import model.components.particleEmitters.ParticleEmitter;
import settings.Settings;

public class ParticleEmitterUniformArea
extends ParticleEmitter {
    private final double[] pos = new double[6];
    private double TIn;
    private double mInParticle;
    private double rIn;

    public ParticleEmitterUniformArea(int numParticlesIn, double x1In, double y1In, double x2In, double y2In, double rIn, double mInAtomic, double mInParticle, double TIn) {
        this.numParticles = numParticlesIn;
        this.mInAtomic = mInAtomic;
        this.TIn = TIn;
        this.mInParticle = mInParticle;
        this.rIn = rIn;
        this.pos[0] = x1In;
        this.pos[1] = y1In;
        this.pos[3] = x2In;
        this.pos[4] = y2In;
        this.pos[2] = Settings.zFront;
        this.pos[5] = Settings.zBack;
        this.particleList = new ArrayList();
        this.initializeParticles();
    }

    public void initializeParticles() {
        Random rand = new Random();
        double[][] randN = new double[this.numParticles][3];
        double G = 0.0;
        for (int i = 0; i < this.numParticles; ++i) {
            for (int j = 0; j < 3; ++j) {
                randN[i][j] = rand.nextGaussian();
                G += randN[i][j] * randN[i][j];
            }
        }
        double scalingConst = Math.sqrt((double)(3 * this.numParticles) * 1.380649E-23 * this.TIn / (G * this.mInAtomic));
        for (int n = 0; n < this.numParticles; ++n) {
            double xTmp = this.pos[0] + (double)rand.nextInt((int)(this.pos[3] - this.pos[0]));
            double yTmp = this.pos[1] + (double)rand.nextInt((int)(this.pos[4] - this.pos[1]));
            double zTmp = this.pos[2] + (double)rand.nextInt((int)(this.pos[5] - this.pos[2]));
            double[] vTmp = new double[]{randN[n][0] * scalingConst, randN[n][1] * scalingConst, randN[n][2] * scalingConst};
            this.particleList.add(new Particle(this.mInAtomic, this.mInParticle, this.rIn, new double[]{xTmp, yTmp, zTmp}, vTmp));
        }
    }

    @Override
    public void draw(Graphics2D context) {
    }

    @Override
    public void update(double dt) {
    }

    @Override
    public HashMap<String, Double> getState() {
        return null;
    }

    @Override
    public double[] getPosition() {
        return this.pos;
    }

    @Override
    public String toXML() {
        return null;
    }

    @Override
    public VTLComponent fromXML(String XMLString) {
        return null;
    }
}

