/*
************************************************************************
*
*   TestSurf.c - test polynominal surface fitting
*
*   Copyright (c) 1994
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 94/06/02
*   Pathname of SCCS file     : /sgiext/molmol/tools/src/SCCS/s.TestSurf.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <polysurf.h>

#include <stdio.h>

#define DEGREE 2
#define COEFF_NO ((DEGREE + 1) * (DEGREE + 2) * (DEGREE + 3) / 6)
#define POINT_NO 20

#define EPS 1.0E-6

main()
{
  float p[POINT_NO][3];
  float coeff[COEFF_NO];
  float nv[3];
  int i;

  p[ 0][0] =  0.0; p[ 0][1] =  2.0; p[ 0][2] =  0.0;
  p[ 1][0] =  1.0; p[ 1][1] =  0.0; p[ 1][2] = -2.0;
  p[ 2][0] =  3.0; p[ 2][1] =  2.0; p[ 2][2] =  0.0;
  p[ 3][0] =  7.0; p[ 3][1] = -1.4; p[ 3][2] =  1.4;
  p[ 4][0] =  8.0; p[ 4][1] =  0.0; p[ 4][2] =  2.0;
  p[ 5][0] = 10.0; p[ 5][1] =  2.0; p[ 5][2] =  0.0;
  p[ 6][0] = 12.0; p[ 6][1] =  0.0; p[ 6][2] = -2.0;
  p[ 7][0] = 13.0; p[ 7][1] =  1.4; p[ 7][2] =  1.4;
  p[ 8][0] = 15.0; p[ 8][1] =  0.0; p[ 8][2] = -2.0;
  p[ 9][0] = 19.0; p[ 9][1] = -2.0; p[ 9][2] =  0.0;
  p[10][0] = 20.0; p[10][1] =  2.0; p[10][2] =  0.0;
  p[11][0] = 22.0; p[11][1] =  1.4; p[11][2] = -1.4;
  p[12][0] = 23.0; p[12][1] =  2.0; p[12][2] =  0.0;
  p[13][0] = 25.0; p[13][1] = -2.0; p[13][2] =  0.0;
  p[14][0] = 28.0; p[14][1] =  0.0; p[14][2] =  2.0;
  p[15][0] = 31.0; p[15][1] =  2.0; p[15][2] =  0.0;
  p[16][0] = 32.0; p[16][1] =  0.0; p[16][2] = -2.0;
  p[17][0] = 34.0; p[17][1] =  0.0; p[17][2] =  2.0;
  p[18][0] = 38.0; p[18][1] = -1.4; p[18][2] = -1.4;
  p[19][0] = 39.0; p[19][1] = -2.0; p[19][2] =  0.0;

  PolysurfFit(p, POINT_NO, coeff, DEGREE);

  for (i = 0; i < COEFF_NO; i++)
    (void) printf("coeff[%d] = %f\n", i, coeff[i]);
  (void) printf("\n");

  for (i = 0; i < POINT_NO; i++) {
    PolysurfNormal(coeff, DEGREE, p[i], nv);
    (void) printf("res[%d] = %f  n = (%f, %f, %f)\n",
	i, PolysurfResidue(coeff, DEGREE, p[i]), nv[0], nv[1], nv[2]);
  }
  (void) printf("\n");

  return 0;
}
