/*
************************************************************************
*
*   TestSpline.c - test splines
*
*   Copyright (c) 1994
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 94/06/02
*   Pathname of SCCS file     : /sgiext/molmol/tools/src/SCCS/s.TestSpline.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cubic_spline.h>

#include <stdio.h>

#include <mat_vec.h>

#define POINT_NO 9
#define STEP_NO 5
#define OUT_NO ((POINT_NO - 1) * STEP_NO + 1)

main()
{
  Vec3 inP[POINT_NO];
  Vec3 outP[OUT_NO];
  int i;

  inP[0][0] = 1.50; inP[0][1] = 0.75; inP[0][2] = 7.0;
  inP[1][0] = 0.90; inP[1][1] = 0.90; inP[1][2] = 7.0;
  inP[2][0] = 0.60; inP[2][1] = 1.00; inP[2][2] = 7.0;
  inP[3][0] = 0.35; inP[3][1] = 0.80; inP[3][2] = 7.0;
  inP[4][0] = 0.20; inP[4][1] = 0.45; inP[4][2] = 7.0;
  inP[5][0] = 0.10; inP[5][1] = 0.20; inP[5][2] = 7.0;
  inP[6][0] = 0.50; inP[6][1] = 0.10; inP[6][2] = 7.0;
  inP[7][0] = 1.00; inP[7][1] = 0.20; inP[7][2] = 7.0;
  inP[8][0] = 1.50; inP[8][1] = 0.25; inP[8][2] = 7.0;

  CubicSplineCalc(inP, POINT_NO, STEP_NO, outP);

  for (i = 0; i < OUT_NO; i++)
    (void) printf("%f %f %f\n", outP[i][0], outP[i][1], outP[i][2]);

  return 0;
}
