#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include <linlist.h>

static int
compElem(void *p1, void *p2)
{
  if (*(int *)p1 < *(int *)p2)
    return -1;
  else
    return 1;
}

int
main(int argc, char *argv[])
{
  LINLIST list;
  clock_t t0;
  int v, *vP;
  int n, i;

  if (argc < 2) {
    (void) fprintf(stderr, "usage: %s elemNo\n", argv[0]);
    return 1;
  }

  n = atoi(argv[1]);

  list = ListOpen(sizeof(int));
  for (i = 0; i < n; i++) {
    v = rand();
    (void) ListInsertLast(list, &v);
  }

  t0 = clock();
  ListSort(list, compElem);
  (void) printf("time: %d\n", clock() - t0);

#if 0
  vP = ListFirst(list);
  while (vP != NULL) {
    (void) printf("%8d\n", *vP);
    vP = ListNext(list, vP);
  }
#endif

  return 0;
}
