/*
************************************************************************
*
*   %M% - test Simplex algorithm
*
*   Copyright (c) 1994-95
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : %E%
*   Pathname of SCCS file     : %P%
*   SCCS identification       : %I%
*
************************************************************************
*/

#include <stdio.h>

#include <simplex.h>

#define VAR_NO 4
#define RESTR_NO 4

main()
{
  float am[(RESTR_NO + 2) * (VAR_NO + 1)];
  float *a[RESTR_NO + 2];
  SimplexRes res;
  float sol[VAR_NO];
  int i, k;

  for (i = 0; i < RESTR_NO + 2; i++)
    a[i] = am + i * (VAR_NO + 1);

  a[0][0] = 0.0;

  a[0][1] = 1.0; a[0][2] = 1.0; a[0][3] = 3.0; a[0][4] = -0.5;

  a[1][1] = -1.0; a[1][2] =  0.0; a[1][3] = -2.0; a[1][4] =  0.0;
  a[2][1] =  0.0; a[2][2] = -2.0; a[2][3] =  0.0; a[2][4] =  7.0;
  a[3][1] =  0.0; a[3][2] = -1.0; a[3][3] =  1.0; a[3][4] = -2.0;
  a[4][1] = -1.0; a[4][2] = -1.0; a[4][3] = -1.0; a[4][4] = -1.0;

  a[1][0] = 740.0;
  a[2][0] = 0.0;
  a[3][0] = 0.5;
  a[4][0] = 9.0;

  res = Simplex(a, VAR_NO, RESTR_NO, 2, 1, 1, sol);
  (void) printf("res = %d\n", res);

  for (i = 0; i < RESTR_NO + 1; i++) {
    for (k = 0; k < VAR_NO + 1; k++)
      (void) printf("%8.5f ", a[i][k]);
    (void) printf("\n");
  }
  (void) printf("\n");

  for (i = 0; i < VAR_NO; i++)
    (void) printf("%8.5f ", sol[i]);
  (void) printf("\n");
  (void) printf("\n");

  return 0;
}
