/*
************************************************************************
*
*   %M% - test singular value decomposition
*
*   Copyright (c) 1994
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : %E%
*   Pathname of SCCS file     : %P%
*   SCCS identification       : %I%
*
************************************************************************
*/

#include <stdio.h>
#include <math.h>

#include <sing_val.h>

#define ROWS 5
#define COLS 3

main()
{
  float am[ROWS * COLS];
  float *a[ROWS];
  float w[COLS];
  float vm[COLS * COLS];
  float *v[COLS];
  float s;
  int i, k, m;

  for (i = 0; i < ROWS; i++)
    a[i] = am + i * COLS;

  for (i = 0; i < COLS; i++)
    v[i] = vm + i * COLS;

  a[0][0] = 11.0; a[0][1] = 12.0; a[0][2] = 13.0;
  a[1][0] = 21.0; a[1][1] = 22.0; a[1][2] = 23.0;
  a[2][0] = 31.0; a[2][1] = 32.0; a[2][2] = 33.0;
  a[3][0] = 41.0; a[3][1] = 42.0; a[3][2] = 43.0;
  a[4][0] = 51.0; a[4][1] = 52.0; a[4][2] = 53.0;

  if (! SingValDecomp(a, ROWS, COLS, w, v)) {
    (void) fprintf(stderr, "error\n");
    return 1;
  }

  for (i = 0; i < ROWS; i++) {
    for (k = 0; k < COLS; k++)
      (void) printf("%8.5f ", a[i][k]);
    (void) printf("\n");
  }
  (void) printf("\n");

  for (i = 0; i < COLS; i++)
    (void) printf("%8.5f ", w[i]);
  (void) printf("\n");
  (void) printf("\n");

  for (i = 0; i < COLS; i++) {
    for (k = 0; k < COLS; k++)
      (void) printf("%8.5f ", v[i][k]);
    (void) printf("\n");
  }
  (void) printf("\n");

  for (i = 0; i < ROWS; i++) {
    for (k = 0; k < COLS; k++) {
      s = 0.0;
      for (m = 0; m < COLS; m++)
	s += a[i][m] * w[m] * v[k][m];
      (void) printf("%8.5f ", s);
    }
    (void) printf("\n");
  }
  (void) printf("\n");

  return 0;
}
