/*
************************************************************************
*
*   TestNLS.c - test non-linear least squares
*
*   Copyright (c) 1994
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 94/06/02
*   Pathname of SCCS file     : /sgiext/molmol/tools/src/SCCS/s.TestNLS.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <least_sqr.h>

#include <stdio.h>
#include <math.h>

#include <mat_vec.h>

#define PARAM_NO 5
#define POINT_NO 10

#define EPS 1.0E-6

main()
{
  float p[POINT_NO][3];
  float m[POINT_NO * PARAM_NO];
  float *c[POINT_NO];
  int avgPointNo;
  float x0[3], x1[3], x2[3], s;
  float d[POINT_NO];
  float tmp[PARAM_NO];
  float sol[PARAM_NO];
  float dsol[PARAM_NO];
  float res[POINT_NO];
  float cx, sx, cy, sy, tx, ty;
  float x, y, z, xt, yt, r;
  float rmsd, a;
  int i;

  p[0][0] =  0.0; p[0][1] =  2.1; p[0][2] =  0.0;
  p[1][0] =  1.0; p[1][1] =  0.0; p[1][2] = -2.0;
  p[2][0] =  3.0; p[2][1] =  2.0; p[2][2] =  0.0;
  p[3][0] =  7.0; p[3][1] = -2.1; p[3][2] =  0.0;
  p[4][0] =  8.0; p[4][1] =  0.0; p[4][2] =  2.1;
  p[5][0] = 10.0; p[5][1] =  2.0; p[5][2] =  0.0;
  p[6][0] = 12.0; p[6][1] =  0.0; p[6][2] = -2.0;
  p[7][0] = 13.0; p[7][1] =  0.0; p[7][2] =  2.0;
  p[8][0] = 15.0; p[8][1] =  0.0; p[8][2] = -2.1;
  p[9][0] = 19.0; p[9][1] = -2.0; p[9][2] =  0.0;

  for (i = 0; i < POINT_NO; i++)
    c[i] = m + i * PARAM_NO;

  avgPointNo = 2 * POINT_NO / 3;
  Vec3Zero(x1);
  Vec3Zero(x2);
  for (i = 0; i < avgPointNo; i++) {
    Vec3Add(x1, p[i]);
    Vec3Add(x2, p[POINT_NO - i]);
  }

  Vec3Scale(x1, 1.0 / (float) avgPointNo);
  Vec3Scale(x2, 1.0 / (float) avgPointNo);
  Vec3Sub(x2, x1);
  Vec3Norm(x2);

  sol[0] = atan(x2[1] / x2[2]);
  cx = cos(sol[0]);
  sx = sin(sol[0]);
  sol[3] = x1[2] * sx - x1[1] * cx;
  sol[1] = atan(x2[0] / (x2[1] * sx + x2[2] * cx));
  cy = cos(sol[1]);
  sy = sin(sol[1]);
  sol[2] = (x1[1] * sx + x1[2] * cx) * sy - x1[0] * cy;
  sol[4] = 0.0;
  for (i = 0; i < POINT_NO; i++) {
    Vec3Copy(x0, p[i]);
    Vec3Sub(x0, x1);
    s = Vec3Scalar(x0, x2);
    sol[4] += Vec3Scalar(x0, x0) - s * s;
  }
  sol[4] /= POINT_NO;

  for (i = 0; i < PARAM_NO; i++)
    (void) printf("sol[%i] = %.6g\n", i, sol[i]);
  (void) printf("\n");

  for (;;) {
    cx = cos(sol[0]);
    sx = sin(sol[0]);
    cy = cos(sol[1]);
    sy = sin(sol[1]);
    tx = sol[2];
    ty = sol[3];
    r = sol[4];

    for (i = 0; i < POINT_NO; i++) {
      x = p[i][0];
      y = p[i][1];
      z = p[i][2];

      xt = x * cy - (y * sx + z * cx) * sy + tx;
      yt = y * cx - z * sx + ty;

      c[i][0] = 2 * xt * (- y * cx + z * sx) * sy +
		2 * yt * (- y * sx - z * cx);
      c[i][1] = 2 * xt * (- x * sy - (y * sx + z * cx) * cy);
      c[i][2] = 2 * xt;
      c[i][3] = 2 * yt;
      c[i][4] = - 2 * r;

      d[i] = xt * xt + yt * yt - r * r;
    }

    LeastSqrMatTransf(c, PARAM_NO, POINT_NO, tmp);
    LeastSqrCalcSol(c, tmp, d, PARAM_NO, POINT_NO, dsol, res);

    for (i = 0; i < PARAM_NO; i++)
      sol[i] += dsol[i];
    
    for (i = 0; i < PARAM_NO; i++)
      (void) printf("sol[%i] = %.6g\n", i, sol[i]);

    rmsd = 0.0;
    for (i = 0; i < POINT_NO; i++)
      rmsd += res[i] * res[i];
    (void) printf("rmsd   = %.6g\n", sqrt(rmsd / POINT_NO));

    a = 0.0;
    for (i = 0; i < PARAM_NO; i++)
      a += dsol[i] * dsol[i];
    a = sqrt(a / PARAM_NO);
    (void) printf("a      = %.6g\n", a);

    if (rmsd < EPS || a < EPS)
      break;

    (void) printf("\n");
  }

  return 0;
}
