/*
************************************************************************
*
*   %M% - test Chebyshev fit
*
*   Copyright (c) 1994-96
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : %E%
*   Pathname of SCCS file     : %P%
*   SCCS identification       : %I%
*
************************************************************************
*/

#include <stdio.h>

#include <cheb_fit.h>

#define COEFF_NO 3
#define POINT_NO 8

static void
fillMat(float **a, float *b)
{
  a[0][0] =  1.0; a[1][0] = 1.0; a[2][0] = 1.0;
  a[0][1] =  4.0; a[1][1] = 2.0; a[2][1] = 1.0;
  a[0][2] =  9.0; a[1][2] = 3.0; a[2][2] = 1.0;
  a[0][3] = 16.0; a[1][3] = 4.0; a[2][3] = 1.0;
  a[0][4] = 25.0; a[1][4] = 5.0; a[2][4] = 1.0;
  a[0][5] = 36.0; a[1][5] = 6.0; a[2][5] = 1.0;
  a[0][6] = 49.0; a[1][6] = 7.0; a[2][6] = 1.0;
  a[0][7] = 64.0; a[1][7] = 8.0; a[2][7] = 1.0;

  b[0] =  3.1;
  b[1] =  5.1;
  b[2] =  7.1;
  b[3] =  9.1;
  b[4] = 11.9;
  b[5] = 13.0;
  b[6] = 15.1;
  b[7] = 17.1;
}

main()
{
  float am[COEFF_NO * POINT_NO];
  float *a[COEFF_NO];
  float b[POINT_NO];
  float sol[COEFF_NO];
  BOOL res;
  float diff;
  int i, k;

  for (i = 0; i < COEFF_NO; i++)
    a[i] = am + i * POINT_NO;

  fillMat(a, b);

  res = ChebyshevFit(a, b, COEFF_NO, POINT_NO, sol);
  (void) printf("res = %d\n", res);

  for (k = 0; k < COEFF_NO; k++)
    (void) printf("%8.5f ", sol[k]);
  (void) printf("\n");
  (void) printf("\n");

  fillMat(a, b);
  for (i = 0; i < POINT_NO; i++) {
    diff = b[i];
    for (k = 0; k < COEFF_NO; k++)
      diff -= a[k][i] * sol[k];
    (void) printf("%8.5f ", diff);
  }
  (void) printf("\n");

  return 0;
}
