/*
************************************************************************
*
*   Queue.c - priority queue manager
*
*   Copyright (c) 1996
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/11/26
*   Pathname of SCCS file     : /local/home/kor/molmol/tools/src/SCCS/s.Queue.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <queue.h>

#include <stdlib.h>
#include <string.h>

struct queueStruc {
  int dataSize;
  QueueCompareFunc compFunc;
  int entryNo;
  int allocNo;
  char *entryA;
  void *tmpP;
};

QUEUE
QueueOpen(int dataSize , QueueCompareFunc compFunc)
{
  QUEUE q;

  q = malloc(sizeof(*q));

  q->dataSize = dataSize;
  q->compFunc = compFunc;
  q->entryNo = 0;
  q->allocNo = 10;
  q->entryA = malloc(q->allocNo * q->dataSize);
  q->tmpP = malloc(q->dataSize);

  return q;
}

void
QueueClose(QUEUE q)
{
  free(q->entryA);
  free(q->tmpP);
  free(q);
}

void
QueuePut(QUEUE q, void *entryP)
{
  int k;

  q->entryNo++;
  if (q->entryNo >= q->allocNo) {
    q->allocNo *= 2;
    q->entryA = realloc(q->entryA, q->allocNo * q->dataSize);
  }

  k = q->entryNo;
  while (k > 1 &&
      q->compFunc(q->entryA + (k / 2) * q->dataSize, entryP) >= 0) {
    (void) memcpy(q->entryA + k * q->dataSize,
	q->entryA + (k / 2) * q->dataSize, q->dataSize);
    k = k / 2;
  }
  (void) memcpy(q->entryA + k * q->dataSize, entryP, q->dataSize);
}

void
QueueGet(QUEUE q, void *entryP)
{
  int k, j;

  (void) memcpy(entryP, q->entryA + q->dataSize, q->dataSize);
  (void) memcpy(q->entryA + q->dataSize,
      q->entryA + q->entryNo * q->dataSize, q->dataSize);
  q->entryNo--;

  k = 1;
  (void) memcpy(q->tmpP, q->entryA + q->dataSize, q->dataSize);
  while (k <= q->entryNo / 2) {
    j = 2 * k;
    if (j < q->entryNo &&
        q->compFunc(q->entryA + j * q->dataSize,
	    q->entryA + (j + 1) * q->dataSize) > 0)
      j++;
    if (q->compFunc(q->tmpP, q->entryA + j * q->dataSize) <= 0)
      break;
    (void) memcpy(q->entryA + k * q->dataSize,
	q->entryA + j * q->dataSize, q->dataSize);
    k = j;
  }
  (void) memcpy(q->entryA + k * q->dataSize, q->tmpP, q->dataSize);
}

int
QueueSize(QUEUE q)
{
  return q->entryNo;
}
