/*
************************************************************************
*
*   FileName.c - file name utility functions
*
*   Copyright (c) 1994
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 94/06/02
*   Pathname of SCCS file     : /sgiext/molmol/tools/src/SCCS/s.FileName.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <file_name.h>

void
FileNamePath(DSTR name)
{
  char *s;
  int lastI;

  s = DStrToStr(name);
  lastI = DStrLen(name) - 1;
  while (lastI >= 0 && s[lastI] != '/')
    lastI--;
  if (lastI >= 0)
    DStrPart(name, 0, lastI);
  else
    DStrAssignStr(name, "");
}

void
FileNameBase(DSTR name)
{
  char *s;
  int firstI, lastI, i;

  s = DStrToStr(name);
  lastI = DStrLen(name) - 1;
  i = lastI;
  while (i >= 0 && s[i] != '.' && s[i] != '/')
    i--;
  if (i >= 0 && s[i] == '.') {
    lastI = i - 1;
    while (i >= 0 && s[i] != '/')
      i--;
  }
  firstI = i + 1;
  DStrPart(name, firstI, lastI);
}

void
FileNameExt(DSTR name)
{
  char *s;
  int len, i;

  s = DStrToStr(name);
  len = DStrLen(name) - 1;
  i = len;
  while (i >= 0 && s[i] != '.' && s[i] != '/')
    i--;
  if (i >= 0 && s[i] == '.')
    DStrPart(name, i + 1, len);
  else
    DStrAssignStr(name, "");
}
