/*
************************************************************************
*
*   EllInteg.c - complete elliptical integrals
*
*   Copyright (c) 1996
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/01/26
*   Pathname of SCCS file     : /sgiext/molmol/tools/src/SCCS/s.EllInteg.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <ell_integ.h>

#include <math.h>
#include <values.h>

#define CA 0.0003

float
EllInteg(float qc, float p, float a, float b)
{
  float e, f, g, em, q;

  qc = fabs(qc);
  e = qc;
  em = 1.0;

  if (p > 0.0) {
    p = sqrt(p);
    b /= p;
  } else {
    f = qc * qc;
    q = 1.0 - f;
    g = 1.0 - p;
    f -= p;
    q *= b - a * p;
    p = sqrt(f / g);
    a = (a - b) / g;
    b = - q / (g * g * p) + a * p;
  }

  for (;;) {
    f = a;
    a += b / p;
    g = e / p;
    b = 2.0 * (b + f * g);
    p += g;
    g = em;
    em += qc;
    if (fabs(g - qc) <= g * CA)
      break;
    
    qc = sqrt(e);
    qc *= 2.0;
    e = qc * em;
  }

  return 0.5 * M_PI * (b + a * em) / (em * (em + p));
}

float
EllInteg1(float k)
{
  return EllInteg(sqrt(1.0 - k * k), 1.0, 1.0, 1.0);
}

float
EllInteg2(float k)
{
  float kc;

  kc = sqrt(1.0 - k * k);
  return EllInteg(kc, 1.0, 1.0, kc * kc);
}
