/*
************************************************************************
*
*   big_int.h - big integer type
*
*   Copyright (c) 1994
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 94/06/02
*   Pathname of SCCS file     : /sgiext/molmol/tools/include/SCCS/s.big_int.h
*   SCCS identification       : 1.1
*
************************************************************************
*/
#ifndef _BIG_INT_H_
#define _BIG_INT_H_

typedef struct big_int *BIGINT;

BIGINT BiNew(void);
void BiFree(BIGINT b);
void BiIntAss(BIGINT b, int i);
void BiStrAss(BIGINT b, char *s);
void BiAss(BIGINT b1, BIGINT b2);
void BiAdd(BIGINT b1, BIGINT b2);
void BiSub(BIGINT b1, BIGINT b2);
void BiMul(BIGINT b1, BIGINT b2);
void BiDiv(BIGINT b1, BIGINT b2);
void BiMod(BIGINT b1, BIGINT b2);
void BiDiv2(BIGINT b);
void BiInc(BIGINT b);
void BiDec(BIGINT b);
int BiOdd(BIGINT b);
int BiZero(BIGINT b);
int BiEqual(BIGINT b1, BIGINT b2);
int BiLess(BIGINT b1, BIGINT b2);
char *BiStr(BIGINT b);
void BiGcd(BIGINT b1, BIGINT b2);

#endif  /* _BIG_INT_H_ */
