/*
************************************************************************
*
*   UiShowSel.c - feedback for interactive selection
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/ui/SCCS/s.UiShowSel.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <ui_show_sel.h>

#include <stdio.h>

#include <dstr.h>
#include <pu.h>
#include <data_hand.h>
#include <data_sel.h>
#include <prim_hand.h>
#include <prim_sel.h>

static void
showSel(DataEntityType entType, void *entP, SelKind kind)
{
  DSTR msg = DStrNew();
  char numBuf[20];
  AttrP attrP = NULL;

  if (kind == SK_ADD)
    DStrAssignStr(msg, "additionally selected ");
  else if (kind == SK_REMOVE)
    DStrAssignStr(msg, "deselected ");
  else
    DStrAssignStr(msg, "selected ");

  switch(entType) {
    case DE_SPEC:
      DStrAppStr(msg, "spec ");
      DStrAppDStr(msg, DhSpecGetName(entP));
      (void) sprintf(numBuf, " (%d)", DhSpecGetNumber(entP));
      DStrAppStr(msg, numBuf);
      attrP = DhSpecGetAttr(entP);
      break;
    case DE_PEAK:
      DStrAppStr(msg, "peak ");
      (void) sprintf(numBuf, " (%d)", DhPeakGetNumber(entP));
      DStrAppStr(msg, numBuf);
      attrP = DhPeakGetAttr(entP);
      break;
    case DE_PRIM:
      DStrAppStr(msg, "primitive ");
      (void) sprintf(numBuf, "%d", PrimGetNumber(entP));
      DStrAppStr(msg, numBuf);
      attrP = PrimGetAttr(entP);
      break;
  }


  if (attrP != NULL) {
    DStrAppStr(msg, " (attr: ");
    (void) sprintf(numBuf, "%d", AttrGetIndex(attrP));
    DStrAppStr(msg, numBuf);
    DStrAppStr(msg, ")");
  }

  PuSetTextField(PU_TF_STATUS, DStrToStr(msg));

  DStrFree(msg);
}

static void
showPrimSel(PrimObjP primP, SelKind kind)
{
  showSel(DE_PRIM, primP, kind);
}

void
UiShowSelInit(void)
{
  SelAddCB(showSel);
  PrimSelAddCB(showPrimSel);
}
