/*
************************************************************************
*
*   PrimDump.c - read/write prim part of dump file
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/prim/SCCS/s.PrimDump.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <prim_hand.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <prop_tab.h>
#include <attr_mng.h>
#include <data_hand.h>
#include "prim_struc.h"

#define CHECK_RES(s) if (s != GF_RES_OK) return FALSE

BOOL
PrimDump(GFile gf)
/* may only be called AFTER DhDump() */
{
  LINLIST primL;
  PrimObjP primP;
  int i, k;

  primL = PrimListGet();

  CHECK_RES(GFileWriteINT32(gf, ListSize(primL)));
  CHECK_RES(GFileWriteNL(gf));
  CHECK_RES(GFileWriteNL(gf));

  primP = ListFirst(primL);
  while (primP != NULL) {
    CHECK_RES(GFileWriteINT16(gf, primP->type));
    CHECK_RES(GFileWriteNL(gf));

    if (primP->specP == NULL) {
      CHECK_RES(GFileWriteINT32(gf, -1));
    } else {
      CHECK_RES(GFileWriteINT32(gf, DhSpecGetNumber(primP->specP)));
    }

    CHECK_RES(GFileWriteNL(gf));

    switch (primP->type) {
      case PT_TEXT:
	for (i = 0; i < 3; i++)
	  CHECK_RES(GFileWriteFLOAT32(gf, primP->u.text.x[i]));
	for (i = 0; i < 3; i++)
	  CHECK_RES(GFileWriteFLOAT32(gf, primP->u.text.dx[i]));
	CHECK_RES(GFileWriteINT32(gf, strlen(primP->u.text.str)));
	CHECK_RES(GFileWriteQuotedStr(gf, primP->u.text.str));
	CHECK_RES(GFileWriteNL(gf));
	break;
      case PT_DRAWOBJ:
	CHECK_RES(GFileWriteINT16(gf, primP->u.drawobj.type));
	CHECK_RES(GFileWriteINT16(gf, primP->u.drawobj.style));
	CHECK_RES(GFileWriteINT32(gf, primP->u.drawobj.pointNo));
	CHECK_RES(GFileWriteNL(gf));
	for (i = 0; i < primP->u.drawobj.pointNo; i++) {
	  for (k = 0; k < 3; k++)
	    CHECK_RES(GFileWriteFLOAT32(gf, primP->u.drawobj.xA[i][k]));
	  for (k = 0; k < 3; k++)
	    CHECK_RES(GFileWriteFLOAT32(gf, primP->u.drawobj.dxA[i][k]));
	  CHECK_RES(GFileWriteNL(gf));
	}
	CHECK_RES(GFileWriteNL(gf));
	break;
    }

    CHECK_RES(GFileWriteINT32(gf, PropGetIndex(primP->propTab)));
    CHECK_RES(GFileWriteINT32(gf, AttrGetIndex(primP->attrP)));
    CHECK_RES(GFileWriteNL(gf));

    primP = ListNext(primL, primP);
  }

  return TRUE;
}

BOOL
PrimUndump(GFile gf, int vers)
/* may only be called AFTER DhUndump() */
{
  int primNo, idx;
  PrimType type;
  DhSpecP specP;
  PrimObjP primP;
  INT32 i32;
  INT16 i16;
  FLOAT32 f32;
  int i, k;

  /* PrimDestroyAll() must be called before! */

  CHECK_RES(GFileReadINT32(gf, &i32));
  primNo = i32;

  for (idx = 0; idx < primNo; idx++) {
    CHECK_RES(GFileReadINT16(gf, &i16));
    type = i16;

    CHECK_RES(GFileReadINT32(gf, &i32));
    if (i32 == -1)
      specP = NULL;
    else
      specP = DhSpecFindNumber(i32);

    primP = PrimNew(type, specP);
    primP->num = idx;

    switch (type) {
      case PT_TEXT:
	for (i = 0; i < 3; i++) {
	  CHECK_RES(GFileReadFLOAT32(gf, &f32));
	  primP->u.text.x[i] = f32;
	}
	for (i = 0; i < 3; i++) {
	  CHECK_RES(GFileReadFLOAT32(gf, &f32));
	  primP->u.text.dx[i] = f32;
	}
	CHECK_RES(GFileReadINT32(gf, &i32));
	primP->u.text.str = malloc(i32 + 1);
	CHECK_RES(GFileReadQuotedStr(gf, primP->u.text.str, i32 + 1));
	break;
      case PT_DRAWOBJ:
	CHECK_RES(GFileReadINT16(gf, &i16));
	primP->u.drawobj.type = i16;
	CHECK_RES(GFileReadINT16(gf, &i16));
	primP->u.drawobj.style = i16;
	CHECK_RES(GFileReadINT32(gf, &i32));
	primP->u.drawobj.pointNo = i32;
	primP->u.drawobj.xA = malloc(primP->u.drawobj.pointNo *
	    sizeof(*primP->u.drawobj.xA));
	primP->u.drawobj.dxA = malloc(primP->u.drawobj.pointNo *
	    sizeof(*primP->u.drawobj.dxA));
	for (i = 0; i < primP->u.drawobj.pointNo; i++) {
	  for (k = 0; k < 3; k++) {
	    CHECK_RES(GFileReadFLOAT32(gf, &f32));
	    primP->u.drawobj.xA[i][k] = f32;
	  }
	  for (k = 0; k < 3; k++) {
	    CHECK_RES(GFileReadFLOAT32(gf, &f32));
	    primP->u.drawobj.dxA[i][k] = f32;
	  }
	}
	break;
    }

    PropFreeTab(primP->propTab);  /* created by PrimNew() */
    CHECK_RES(GFileReadINT32(gf, &i32));
    primP->propTab = PropGet(PropFindIndex(i32));

    AttrReturn(primP->attrP);  /* created by PrimNew() */
    CHECK_RES(GFileReadINT32(gf, &i32));
    primP->attrP = AttrGet(AttrFindIndex(i32));
  }

  PropUndumpEnd();
  AttrUndumpEnd();

  return TRUE;
}
