/*
************************************************************************
*
*   OsSleep.c - sleep
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/os/SCCS/s.OsSleep.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <os_sleep.h>

#undef _POSIX_SOURCE  /* select is not a POSIX function */

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>

#ifndef _AIX
/* prototype missing in system header files */
extern int select(int, fd_set *, fd_set *, fd_set *, struct timeval *);
#endif

void
OsSleep(int delay)
{
  struct timeval timeS;

  timeS.tv_sec = delay / 1000;
  timeS.tv_usec = (delay % 1000) * 1000;

  (void) select(0, NULL, NULL, NULL, &timeS);
}
