/*
************************************************************************
*
*   MotifMsg.c - Motif message dialogs
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/motif/SCCS/s.MotifMsg.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include "motif_msg.h"

#include <Xm/MessageB.h>

#include "motif_access.h"

void
PuMotifShowMessage(PuMessageType type, char *title, char *msg)
{
  Widget dialogW;
  int dialogType;
  XmString titleStr, msgStr;

  switch (type) {
    case PU_MT_BUSY:
      dialogType = XmDIALOG_WORKING;
      break;
    case PU_MT_INFO:
      dialogType = XmDIALOG_INFORMATION;
      break;
    case PU_MT_QUESTION:
      dialogType = XmDIALOG_QUESTION;
      break;
    case PU_MT_WARNING:
      dialogType = XmDIALOG_WARNING;
      break;
    case PU_MT_ERROR:
      dialogType = XmDIALOG_ERROR;
      break;
  }

  dialogW = XmCreateMessageDialog(MotifGetTopW(), "message", NULL, 0);
  titleStr = XmStringCreateSimple(title);
  msgStr = XmStringCreateLtoR(msg, XmSTRING_DEFAULT_CHARSET);
  XtVaSetValues(dialogW,
      XmNdialogType, dialogType,
      XmNdialogTitle, titleStr,
      XmNmessageString, msgStr,
      XmNdeleteResponse, XmDESTROY,
      NULL);
  XmStringFree(titleStr);
  XmStringFree(msgStr);

  XtUnmanageChild(
      XmMessageBoxGetChild(dialogW, XmDIALOG_CANCEL_BUTTON));
  XtSetSensitive(
      XmMessageBoxGetChild(dialogW, XmDIALOG_HELP_BUTTON), False);

  XtManageChild(dialogW);
}

void
PuMotifBeep(void)
{
  Display *dpy = XtDisplay(MotifGetTopW());

  XBell(dpy, 100);
}
