/*
************************************************************************
*
*   Autopsy.c - main program
*
*   Copyright (c) 1994-96
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/main/SCCS/s.Autopsy.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <io.h>
#include <pu.h>
#include <sg.h>
#include <g_file.h>
#include <prog_vers.h>
#include <prog_dir.h>
#include <curr_dir.h>
#include <user_file.h>
#include <setup_file.h>
#include <par_names.h>
#include <par_hand.h>
#include <data_hand.h>
#include <prim_hand.h>
#include <graph_draw.h>
#include <graph_input.h>
#include <graph_text.h>
#include <graph_dobj.h>
#include <ui_menu.h>
#include <ui_cmd_field.h>
#include <ui_valuator.h>
#include <ui_show_sel.h>
#include <ui_switch.h>
#include <cip.h>
#include <arg.h>

static BOOL X11Features[SG_FEATURE_NO] = {0, 0, 1, 1, 0, 0, 0, 0};
static BOOL XGLFeatures[SG_FEATURE_NO] = {0, 0, 0, 1, 1, 1, 0, 1};
static BOOL GLFeatures[SG_FEATURE_NO] =  {0, 0, 0, 0, 1, 0, 0, 1};

static void
printMsg(char* dev)
{
/*PG
  (void) fprintf(stderr, "\n%s %d.%d.%d %s\n",
      PROG_NAME, VERS_MAJOR, VERS_MINOR, VERS_REV, VERS_STATE);
  (void) fprintf(stderr, "\nCopyright (c) 1994-96 by\n");
  (void) fprintf(stderr,
      "    Institut fuer Molekularbiologie und Biophysik, ETH Zurich\n");
  (void) fprintf(stderr, "    Spectrospin AG, Faellanden, Switzerland\n");
*/
  (void) fprintf(stderr, "\n%s %d.%d (%s)\n",
      PROG_NAME, VERS_MAJOR, VERS_MINOR, dev);
  (void) fprintf(stderr, "\nCopyright (c) 1994-2001 by ETH Zurich and Bruker AG\n");
}

static void
setFeatures(char *dev)
{
  BOOL *features;
  int i;

  if (ParDefined(PN_GRAPH_DEV) &&
      ParGetArrSize(PN_RENDERING) == SG_FEATURE_NO &&
      strcmp(ParGetStrVal(PN_GRAPH_DEV), dev) == 0) {
    /* same device, use values from parameter file */
    for (i = 0; i < SG_FEATURE_NO; i++)
      SgSetFeature(i, ParGetIntArrVal(PN_RENDERING, i));
  } else {
    /* different device, use default values */
    if (strcmp(dev, "X11") == 0)
      features = X11Features;
    else if (strcmp(dev, "XGL") == 0)
      features = XGLFeatures;
    else
      features = GLFeatures;

    for (i = 0; i < SG_FEATURE_NO; i++) {
      ParSetIntArrVal(PN_RENDERING, i, features[i]);
      SgSetFeature(i, features[i]);
    }
  }
}

static void
quitCB(void *clientData)
{
  GFile gf;
  BOOL ok;

  gf = UserFileOpenWrite("par", GF_FORMAT_ASCII);
  if (gf != NULL) {
    (void) ParDump(gf);
    GFileClose(gf);
  }
}

static void
handleFileError(char *fileName, char *errMsg)
{
  DSTR errStr;

  errStr = DStrNew();
  DStrAppStr(errStr, fileName);
  DStrAppStr(errStr, ": ");
  DStrAppStr(errStr, errMsg);
  CipSetError(DStrToStr(errStr));
  DStrFree(errStr);
}

static void
handleIOError(char *errMsg)
{
  CipSetError(errMsg);
}

int
main(int argc, char *argv[])
{
  char *dev;
  GFile gf;
  DSTR helpDir;
  char *startupName, *optName;

  dev = getenv("AUTOPSYDEV");
  printf("dev=%s\n",dev);
  if (dev == NULL)
    dev = "Motif/X11";
  printMsg(dev);
  if (IOSetDevice(dev) != IO_RES_OK) {
    (void) fprintf(stderr, "unknown IO device\n");
    exit(1);
  }

  SgSetDoubleBuffer(TRUE);

  ProgDirSet("AUTOPSYHOME", "/usr/autopsy");
  SetupSetDir("setup");
  UserFileSetDir(CurrDirGet(), "autopsy");
  GFileSetErrorHandler(handleFileError);

  if (IOInit(PROG_NAME, &argc, argv) != IO_RES_OK) {
    (void) fprintf(stderr, "initialization of IO failed\n");
    exit(1);
  }

  IOSetErrorHandler(handleIOError);

  PuSetTextField(PU_TF_TITLE,
      "AUTOPSY - AUTOmatic Peak picking in nmr SpectroscopY");

  gf = UserFileOpenRead("par");
  if (gf != NULL) {
    (void) ParUndump(gf);
    GFileClose(gf);
  }

  GraphDrawInit();
  GraphInputInit();
  GraphTextInit();
  GraphDrawobjInit();
  GraphRedrawEnable(FALSE);

  while (*dev != '/')
    dev++;
  dev++;
  setFeatures(dev);
  ParSetStrVal(PN_GRAPH_DEV, dev);

  UiMenuCreateBar();
  UiMenuCreatePopup();
  UiCmdFieldsCreate();
  UiValuatorCreate();
  UiShowSelInit();
  UiSwitch();

  helpDir = DStrNew();
  DStrAssignStr(helpDir, ProgDirGet());
  DStrAppStr(helpDir, "/help");
  CipInit(DStrToStr(helpDir));
  DStrFree(helpDir);

  PuAddQuitCB(quitCB, NULL, NULL);
  GraphRedrawEnable(TRUE);
  ArgEnable(TRUE);

  startupName = UserFileGetName("startup.mac");
  optName = UserFileGetName("options.mac");
  CipCmdSeqBegin();
  (void) CipExecFile(startupName);
  (void) CipExecFile(optName);
  CipCmdSeqEnd();
  free(startupName);
  free(optName);

  PuEventLoop();

  return 0;
}
