/*
************************************************************************
*
*   GraphTransf.c - transformations of graphical display
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/graph/SCCS/s.GraphTransf.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <graph_transf.h>

#include <values.h>
#include <math.h>

#include <data_hand.h>

typedef struct {
  Mat4 rotM;
  Vec3 transV;
  BOOL transSet;
} RotData;

float
GraphDegToRad(float ang)
{
  return ang / 180.0 * M_PI;
}

static void
specRotate(DhSpecP specP, void *clientData)
{
  RotData *rotP = clientData;
  Mat4 m, rotM;
  Vec3 transV;
  Vec4 v4;

  Mat4Copy(m, rotP->rotM);
  DhSpecGetRotMat(specP, rotM);
  Mat4Mult(m, rotM);
  Mat4Ortho(m);
  DhSpecSetRotMat(specP, m);

  /* adapt translation vectors so that all spectra rotate simultanously */
  if (rotP->transSet) {
    DhSpecGetTransVect(specP, transV);
    Vec3Sub(transV, rotP->transV);
    Vec3To4(v4, transV);
    Mat4VecMult(v4, rotP->rotM);
    Vec4To3(transV, v4);
    Vec3Add(transV, rotP->transV);
    DhSpecSetTransVect(specP, transV);
  } else {
    DhSpecGetTransVect(specP, rotP->transV);
    rotP->transSet = TRUE;
  }
}

void
GraphRotate(Mat4 m)
{
  RotData data;

  Mat4Copy(data.rotM, m);
  data.transSet = FALSE;
  DhApplySpec(PropGetRef(PROP_MOVABLE, FALSE), specRotate, &data);
}

void
GraphRotateX(float ang)
{
  Mat4 m;
  float c = cos(ang);
  float s = sin(ang);

  Mat4Ident(m);
  m[1][1] = c;
  m[2][2] = c;
  m[1][2] = s;
  m[2][1] = -s;

  GraphRotate(m);
}

void
GraphRotateY(float ang)
{
  Mat4 m;
  float c = cos(ang);
  float s = sin(ang);

  Mat4Ident(m);
  m[0][0] = c;
  m[2][2] = c;
  m[0][2] = s;
  m[2][0] = -s;

  GraphRotate(m);
}

void
GraphRotateZ(float ang)
{
  Mat4 m;
  float c = cos(ang);
  float s = sin(ang);

  Mat4Ident(m);
  m[0][0] = c;
  m[1][1] = c;
  m[0][1] = s;
  m[1][0] = -s;

  GraphRotate(m);
}

static void
specTranslate(DhSpecP specP, void *clientData)
{
  Vec3 transV;

  DhSpecGetTransVect(specP, transV);
  Vec3Add(transV, clientData);
  DhSpecSetTransVect(specP, transV);
}

void
GraphMove(Vec3 d)
{
  DhApplySpec(PropGetRef(PROP_MOVABLE, FALSE),  specTranslate, d);
}
