/*
************************************************************************
*
*   ExprScan.c - expression scanner
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/expr/SCCS/s.ExprScan.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include "expr_scan.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include <bool.h>
#include <dstr.h>

static int IntVal;
static float FloatVal;
static DSTR StrVal = NULL;

static char *ExprStr;

void
ExprScanStart(char *exprStr)
{
  ExprStr = exprStr - 1;  /* will be incremented before first use */

  if (StrVal == NULL)
    StrVal = DStrNew();
}

static ExprSym
lookupIdent(void)
{
  char *s = DStrToStr(StrVal);

  if (strcmp(s, "sqrt") == 0)
    return ES_SQRT;
  if (strcmp(s, "log") == 0)
    return ES_LOG;
  if (strcmp(s, "not") == 0)
    return ES_NOT;
  if (strcmp(s, "or") == 0)
    return ES_OR;
  if (strcmp(s, "and") == 0)
    return ES_AND;


  if (strcmp(s, "exists") == 0)
    return ES_EXISTS;
  if (strcmp(s, "all") == 0)
    return ES_ALL;

  if (strcmp(s, "spec") == 0)
    return ES_SPEC;
  if (strcmp(s, "peak") == 0)
    return ES_PEAK;
  if (strcmp(s, "prim") == 0)
    return ES_PRIM;

  if (strcmp(s, "num") == 0)
    return ES_NUMBER;
  if (strcmp(s, "number") == 0)
    return ES_NUMBER;
  if (strcmp(s, "name") == 0)
    return ES_NAME;
  if (strcmp(s, "amp") == 0)
    return ES_AMP;
  if (strcmp(s, "symm") == 0)
    return ES_SYMM;
  if (strcmp(s, "unif") == 0)
    return ES_UNIF;
  if (strcmp(s, "qual") == 0)
    return ES_QUAL;
  if (strcmp(s, "shift0") == 0)
    return ES_SHIFT0;
  if (strcmp(s, "shift1") == 0)
    return ES_SHIFT1;
  if (strcmp(s, "shift2") == 0)
    return ES_SHIFT2;
  if (strcmp(s, "shift3") == 0)
    return ES_SHIFT3;
  if (strcmp(s, "shift4") == 0)
    return ES_SHIFT4;
  if (strcmp(s, "width0") == 0)
    return ES_WIDTH0;
  if (strcmp(s, "width1") == 0)
    return ES_WIDTH1;
  if (strcmp(s, "width2") == 0)
    return ES_WIDTH2;
  if (strcmp(s, "width3") == 0)
    return ES_WIDTH3;
  if (strcmp(s, "width4") == 0)
    return ES_WIDTH4;
  if (strcmp(s, "attr") == 0)
    return ES_ATTR;

  return ES_IDENT;
}

ExprSym
ExprScanGetSym(void)
{
  char ch;
  BOOL isFloat;

  do
    ExprStr++;
  while (ExprStr[0] == ' ');

  switch (ExprStr[0]) {
    case '+':
      return ES_PLUS;
    case '-':
      return ES_MINUS;
    case '*':
      return ES_MUL;
    case '/':
      return ES_DIV;
    case '%':
      return ES_REM;
    case '=':
      if (ExprStr[1] == '=')
	ExprStr++;
      return ES_EQU;
    case '!':
      if (ExprStr[1] == '=') {
	ExprStr++;
	return ES_NEQ;
      }
      return ES_NOT;
    case '<':
      if (ExprStr[1] == '=') {
	ExprStr++;
	return ES_LEQ;
      } else if (ExprStr[1] == '>') {
	ExprStr++;
	return ES_NEQ;
      }
      return ES_LSS;
    case '>':
      if (ExprStr[1] == '=') {
	ExprStr++;
	return ES_GEQ;
      }
      return ES_GTR;
    case '|':
      if (ExprStr[1] == '|')
	ExprStr++;
      return ES_OR;
    case '&':
      if (ExprStr[1] == '&')
	ExprStr++;
      return ES_AND;
    case '.':
      if (ExprStr[1] == '.') {
        ExprStr++;
        return ES_RANGE;
      }
      return ES_DOT;
    case ':':
      return ES_COLON;
    case '(':
      return ES_LPAR;
    case ')':
      return ES_RPAR;
    case ',':
      return ES_COMMA;
    case '\0':
      return ES_END;
    default:
      ch = ExprStr[0];
      DStrAssignStr(StrVal, "");
      if (isdigit(ch)) {
        isFloat = FALSE;
	for (;;) {
	  if (isdigit(ch)) {
	    DStrAppChar(StrVal, ch);
          } else if (ch == '.' && ExprStr[1] != '.' ||
              ch == 'e' || ch == 'E') {
	    DStrAppChar(StrVal, ch);
	    isFloat = TRUE;
	  } else {
	    break;
	  }
	  ExprStr++;
	  ch = ExprStr[0];
	}
	ExprStr--;
	if (isFloat) {
	  FloatVal = atof(DStrToStr(StrVal));
	  return ES_FLOAT;
	} else {
	  IntVal = atoi(DStrToStr(StrVal));
	  return ES_INT;
	}
      } else if (isalpha(ch)) {
	while (isalnum(ch) || ch == '_') {
	  DStrAppChar(StrVal, ch);
	  ExprStr++;
	  ch = ExprStr[0];
	}
	ExprStr--;
	return lookupIdent();
      } else if (ch == '"') {
	ExprStr++;
	ch = ExprStr[0];
	while (ch != '"' && ch != '\0') {
	  DStrAppChar(StrVal, ch);
	  ExprStr++;
	  ch = ExprStr[0];
	}
	if (ch == '"')
	  return ES_STR;
      }
      return ES_UNKNOWN;
  }  /* switch */
}

int
ExprScanGetInt(void)
{
  return IntVal;
}

float
ExprScanGetFloat(void)
{
  return FloatVal;
}

char *
ExprScanGetStr(void)
{
  return DStrToStr(StrVal);
}
