/*
************************************************************************
*
*   ExNoise.c - Noise command
*
*   Copyright (c) 1994-95
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdstruc/SCCS/s.ExNoise.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_struc.h>

#include <stdio.h>

#include <data_hand.h>
#include <graph_draw.h>

static void
addNoise(DhSpecP specP, void *clientData)
{
  DhSpecP noiseP;

  noiseP = DhSpecNewNoise(specP);
  if (noiseP != NULL)
    GraphSpecAdd(noiseP);
}

ErrCode
ExNoise(char *cmd)
{
  DhApplySpec(PropGetRef(PROP_SELECTED, FALSE), addNoise, NULL);
  GraphRedrawNeeded();

  return EC_OK;
}
