/*
************************************************************************
*
*   ExDeconv.c - Deconv command
*
*   Copyright (c) 1994-96
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdstruc/SCCS/s.ExDeconv.c
*   SCCS identification       : 1.2
*
************************************************************************
*/

#include <cmd_struc.h>

#include <stdio.h>

#include <break.h>
#include <hashtab.h>
#include <app/shape_list.h>
#include <app/deconv.h>
#include <pu.h>
#include <arg.h>
#include <data_hand.h>
#include <data_sel.h>
#include <graph_draw.h>

static float MinLevel = 2.0;
static float MinMatch = 0.2;
static int SpecNo, SpecI;
static int PeakNo;

typedef struct {
  HASHTABLE hashTab;
  DhSpecP specP;
} PeakData;

static unsigned
hashFunc(void *p, unsigned size)
{
  AppPeakP *appPeakPP = p;

  return (unsigned) *appPeakPP % size;
}

static int
compFunc(void *p1, void *p2)
{
  AppPeakP *appPeak1PP = p1;
  AppPeakP *appPeak2PP = p2;

  if (*appPeak1PP == *appPeak2PP)
    return 0;
  else
    return 1;
}

static void
getPeak(AppPeakP appPeakP, void *clientData)
{
  HASHTABLE hashTab = clientData;

  (void) HashInsert(hashTab, &appPeakP, FALSE);
}

static void
getSpecPeaks(DhSpecP specP, void *clientData)
{
  HASHTABLE hashTab = clientData;
  AppSpectrumP appSpecP;

  appSpecP = DhSpecGetApp(specP);
  if (appSpecP == NULL)
    return;

  AppPeakApply(appSpecP, getPeak, hashTab);
}

static void
checkPeak(AppPeakP appPeakP, void *clientData)
{
  PeakData *dataP = clientData;

  if (HashSearch(dataP->hashTab, &appPeakP) != NULL)
    return;

  (void) DhPeakNew(dataP->specP, appPeakP);

  PeakNo++;

}

static void
checkSpecPeaks(DhSpecP specP, void *clientData)
{
  HASHTABLE hashTab = clientData;
  AppSpectrumP appSpecP;
  PeakData peakData;

  appSpecP = DhSpecGetApp(specP);
  if (appSpecP == NULL)
    return;

  peakData.hashTab = hashTab;
  peakData.specP = specP;

  AppPeakApply(appSpecP, checkPeak, &peakData);
}

static void
deconvReg(DhSpecP regP, void *clientData)
{
  char buf[50];

  SpecI++;

  if (DhSpecGetType(regP) != ST_REGION)
    return;

  if (BreakCheck(1))
    return;

  (void) sprintf(buf, "Deconvol: %5d / %5d\n", SpecI, SpecNo);
  PuSetTextField(PU_TF_STATUS, buf);

  PeakNo = 0;
  AppDeconvol(DhRegGetApp(regP), MinLevel, MinMatch);
}

#define ARG_NUM 2

ErrCode
ExDeconv(char *cmd)
{
  ArgDescr arg[ARG_NUM];
  ErrCode errCode;
  PropRefP refP;
  HASHTABLE oldTab;

  arg[0].type = AT_DOUBLE;
  arg[1].type = AT_DOUBLE;

  ArgInit(arg, ARG_NUM);

  arg[0].prompt = "Min. Level.";
  arg[0].v.doubleVal = MinLevel;

  arg[1].prompt = "Min. Match";
  arg[1].v.doubleVal = MinMatch;

  errCode = ArgGet(arg, ARG_NUM);
  if (errCode != EC_OK) {
    ArgCleanup(arg, ARG_NUM);
    return errCode;
  }

  MinLevel = arg[0].v.doubleVal;
  MinMatch = arg[1].v.doubleVal;

  ArgCleanup(arg, ARG_NUM);

  refP = PropGetRef(PROP_SELECTED, FALSE);

  oldTab = HashOpen(997, sizeof(AppPeakP), hashFunc, compFunc);
  DhApplySpec(refP, getSpecPeaks, oldTab);

  BreakActivate(TRUE);

  SpecNo = SelSpecGet(NULL, 0);
  SpecI = 0;
  DhApplySpec(refP, deconvReg, NULL);

  BreakActivate(FALSE);

  DhApplySpec(refP, checkSpecPeaks, oldTab);
  HashClose(oldTab);

  GraphRedrawNeeded();

  return EC_OK;
}
