/*
************************************************************************
*
*   ExResol.c - Resolution command
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdrep/SCCS/s.ExResol.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_rep.h>

#include <stdlib.h>

#include <arg.h>
#include <data_hand.h>
#include <data_sel.h>
#include <graph_draw.h>

typedef struct {
  int dim;
  int r[APP_MAX_DIM];
} Resol;

static void
setResol(DhSpecP specP, void *clientData)
{
  Resol *resolP = clientData;

  if (DhSpecGetDim(specP) != resolP->dim)
    return;
  
  DhSpecSetResol(specP, resolP->r);
}

ErrCode
ExResolution(char *cmd)
{
  ArgDescr *argP;
  ErrCode errCode;
  int selNo;
  Resol resol;
  DhSpecP specP;
  int i;

  selNo = SelSpecGet(&specP, 1);
  if (selNo > 0)
    resol.dim = DhSpecGetDim(specP);
  else
    resol.dim = 2;

  for (i = 0; i < resol.dim; i++)
    resol.r[i] = 64;

  argP = malloc(resol.dim * sizeof(*argP));

  for (i = 0; i < resol.dim; i++)
    argP[i].type = AT_INT;

  ArgInit(argP, resol.dim);

  for (i = 0; i < resol.dim; i++) {
    argP[i].prompt = "";
    argP[i].v.intVal = resol.r[i];
  }

  errCode = ArgGet(argP, resol.dim);
  if (errCode != EC_OK) {
    ArgCleanup(argP, resol.dim);
    free(argP);
    return errCode;
  }

  for (i = 0; i < resol.dim; i++)
    resol.r[i] = argP[i].v.intVal;

  DhApplySpec(PropGetRef(PROP_SELECTED, FALSE), setResol, &resol);

  ArgCleanup(argP, resol.dim);
  free(argP);

  GraphRedrawNeeded();

  return EC_OK;
}
