/*
************************************************************************
*
*   ExExpand.c - Rotate* commands
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdrep/SCCS/s.ExExpand.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_rep.h>

#include <stdlib.h>

#include <arg.h>
#include <data_hand.h>
#include <data_sel.h>
#include <graph_draw.h>

typedef struct {
  int dim;
  int coord[APP_MAX_DIM][2];
} Ranges;

static void
setRange(DhSpecP specP, void *clientData)
{
  Ranges *rangesP = clientData;

  if (DhSpecGetDim(specP) != rangesP->dim)
    return;
  
  DhSpecSetRegion(specP, rangesP->coord);
}

ErrCode
ExExpand(char *cmd)
{
  ArgDescr arg[2 * APP_MAX_DIM];
  ErrCode errCode;
  int selNo;
  Ranges ranges;
  DhSpecP specP;
  int sizes[APP_MAX_DIM];
  int i;

  selNo = SelSpecGet(&specP, 1);
  if (selNo > 0) {
    ranges.dim = DhSpecGetDim(specP);
    DhSpecGetSizes(specP, sizes);
  } else {
    ranges.dim = 2;
    for (i = 0; i < ranges.dim; i++)
      sizes[i] = 1;
  }

  for (i = 0; i < 2 * ranges.dim; i++)
    arg[i].type = AT_INT;

  ArgInit(arg, 2 * ranges.dim);

  for (i = 0; i < ranges.dim; i++) {
    arg[2 * i].prompt = "min";
    arg[2 * i].v.intVal = 0;
    arg[2 * i + 1].prompt = "max";
    arg[2 * i + 1].v.intVal = sizes[i] - 1;
  }

  errCode = ArgGet(arg, 2 * ranges.dim);
  if (errCode != EC_OK) {
    ArgCleanup(arg, 2 * ranges.dim);
    return errCode;
  }

  for (i = 0; i < ranges.dim; i++) {
    ranges.coord[i][0] = arg[2 * i].v.intVal;
    ranges.coord[i][1] = arg[2 * i + 1].v.intVal;
  }

  DhApplySpec(PropGetRef(PROP_SELECTED, FALSE), setRange, &ranges);

  ArgCleanup(arg, 2 * ranges.dim);

  GraphRedrawNeeded();

  return EC_OK;
}
