/*
************************************************************************
*
*   ExClipPlanes.c - Clip* commands
*
*   Copyright (c) 1994-95
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdrep/SCCS/s.ExClipPlanes.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_rep.h>

#include <string.h>

#include <sg.h>
#include <arg.h>
#include <par_names.h>
#include <par_hand.h>
#include <graph_draw.h>

#define ARG_NUM 1

ErrCode
ExClip(char *cmd)
{
  BOOL isPos = (strcmp(cmd, "ClipPos") == 0);
  ArgDescr arg[ARG_NUM];
  ErrCode errCode;
  float near, far, pos, size;

  arg[0].type = AT_DOUBLE;

  ArgInit(arg, ARG_NUM);

  near = ParGetDoubleVal(PN_NEAR_PLANE);
  far = ParGetDoubleVal(PN_FAR_PLANE);
  pos = 0.5 * (near + far);
  size = far - near;

  if (isPos) {
    arg[0].prompt = "Clip Position";
    arg[0].v.doubleVal = pos;
  } else {
    arg[0].prompt = "Clip Size";
    arg[0].v.doubleVal = size;
  }

  errCode = ArgGet(arg, ARG_NUM);
  if (errCode != EC_OK) {
    ArgCleanup(arg, ARG_NUM);
    return errCode;
  }

  if (isPos) {
    pos = arg[0].v.doubleVal;
    if (pos < 0.1)
      pos = 0.1;
  } else {
    size = arg[0].v.doubleVal;
    if (size < 0.1)
      size = 0.1;
  }

  ArgCleanup(arg, ARG_NUM);

  near = pos - 0.5 * size;
  far = pos + 0.5 * size;

  ParSetDoubleVal(PN_NEAR_PLANE, near);
  ParSetDoubleVal(PN_FAR_PLANE, far);
  SgSetNearPlane(near, TRUE);
  SgSetFarPlane(far, TRUE);

  SgUpdateView();
  GraphRedrawNeeded();

  return EC_OK;
}
