/*
************************************************************************
*
*   ExListProp.c - ListProp* commands
*
*   Copyright (c) 1994-96
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdprop/SCCS/s.ExListProp.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_prop.h>

#include <stdio.h>
#include <string.h>

#include <pu.h>
#include <prop_tab.h>
#include <data_hand.h>
#include <prim_hand.h>

PuTextWindow TextW;

typedef struct {
  int entNo;
  unsigned *propTab;
} PropDescr;

static void
getProp(unsigned *propTab, PropDescr *descrP)
{
  if (descrP->entNo == 0)
    descrP->propTab = propTab;
  else if (descrP->propTab != propTab)
    descrP->propTab = NULL;

  descrP->entNo++;
}

static void
getPropSpec(DhSpecP specP, void *clientData)
{
  getProp(DhSpecGetPropTab(specP), clientData);
}

static void
getPropPeak(DhPeakP peakP, void *clientData)
{
  getProp(DhPeakGetPropTab(peakP), clientData);
}

static void
getPropPrim(PrimObjP primP, void *clientData)
{
  getProp(PrimGetPropTab(primP), clientData);
}

static void
listProp(char *name, void *clientData)
{
  if (name[0] == '_')
    /* do not list internally used properties */
    return;

  PuWriteStr(TextW, name);
  PuWriteStr(TextW, "\n");
}

ErrCode
ExListProp(char *cmd)
{
  PropDescr descr;
  PropRefP refP;

  descr.entNo = 0;
  descr.propTab = NULL;

  refP = PropGetRef(PROP_SELECTED, FALSE);

  if (strcmp(cmd, "ListPropSpec") == 0)
    DhApplySpec(refP, getPropSpec, &descr);
  else if (strcmp(cmd, "ListPropPeak") == 0)
    DhApplyPeak(refP, getPropPeak, &descr);
  else
    PrimApply(PT_ALL, refP, getPropPrim, &descr);

  if (descr.entNo == 0) {
    CipSetError("no item selected");
    return EC_ERROR;
  }

  if (descr.propTab == NULL) {
    CipSetError("not all selected items have same properties");
    return EC_ERROR;
  }

  TextW = PuCreateTextWindow(cmd);

  PropList(descr.propTab, listProp, NULL);

  return EC_OK;
}
