/*
************************************************************************
*
*   ExText.c - AddTitle and AddText commands
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdprim/SCCS/s.ExText.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_prim.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <arg.h>
#include <data_hand.h>
#include <data_sel.h>
#include <prim_hand.h>
#include <attr_struc.h>
#include <attr_mng.h>
#include <graph_input.h>
#include <graph_draw.h>

static float CurrSize = 0.05;

#define ARG_NUM 4

ErrCode
ExAddTitle(char *cmd)
{
  ArgDescr arg[ARG_NUM];
  ErrCode errCode;
  PrimObjP primP;
  float x0, y0;
  Vec3 x, dx;
  AttrP attrP;
  struct AttrS attr;

  GraphInputGetClick(&x0, &y0);

  arg[0].type = AT_DOUBLE;
  arg[1].type = AT_DOUBLE;
  arg[2].type = AT_DOUBLE;
  arg[3].type = AT_STR;

  ArgInit(arg, ARG_NUM);

  arg[0].prompt = "Pos x";
  arg[0].v.doubleVal = x0;

  arg[1].prompt = "Pos y";
  arg[1].v.doubleVal = y0;

  arg[2].prompt = "Size";
  arg[2].v.doubleVal = CurrSize;

  arg[3].prompt = "String";

  errCode = ArgGet(arg, ARG_NUM);
  if (errCode != EC_OK) {
    ArgCleanup(arg, ARG_NUM);
    return errCode;
  }

  CurrSize = arg[2].v.doubleVal;

  primP = PrimNew(PT_TEXT, NULL);

  x[0] = arg[0].v.doubleVal;
  x[1] = arg[1].v.doubleVal;
  x[2] = 0.0;
  PrimSetPos(primP, x);
  Vec3Zero(dx);
  PrimSetVec(primP, dx);
  PrimSetText(primP, DStrToStr(arg[3].v.strVal));

  ArgCleanup(arg, ARG_NUM);

  attrP = PrimGetAttr(primP);
  AttrCopy(&attr, attrP);
  AttrReturn(attrP);
  attr.fontSize = CurrSize;
  PrimSetAttr(primP, AttrGet(&attr));
  
  GraphRedrawNeeded();

  return EC_OK;
}

#undef ARG_NUM
#define ARG_NUM 2

ErrCode
ExAddText(char *cmd)
{
  ArgDescr arg[ARG_NUM];
  ErrCode errCode;
  DhSpecP specP;
  PrimObjP primP;
  Vec3 x, dx;
  AttrP attrP;
  struct AttrS attr;

  arg[0].type = AT_DOUBLE;
  arg[1].type = AT_STR;

  ArgInit(arg, ARG_NUM);

  arg[0].prompt = "Size";
  arg[0].v.doubleVal = CurrSize;

  arg[1].prompt = "String";

  errCode = ArgGet(arg, ARG_NUM);
  if (errCode != EC_OK) {
    ArgCleanup(arg, ARG_NUM);
    return errCode;
  }

  CurrSize = arg[0].v.doubleVal;

  if (SelSpecGet(&specP, 1) != 1) {
    CipSetError("exactly 1 spec must be selected");
    ArgCleanup(arg, ARG_NUM);
    return EC_ERROR;
  }

  primP = PrimNew(PT_TEXT, specP);

  Vec3Zero(x);
  PrimSetPos(primP, x);
  Vec3Zero(dx);
  PrimSetVec(primP, dx);

  PrimSetText(primP, DStrToStr(arg[1].v.strVal));

  ArgCleanup(arg, ARG_NUM);

  attrP = PrimGetAttr(primP);
  AttrCopy(&attr, attrP);
  AttrReturn(attrP);
  attr.fontSize = CurrSize;
  PrimSetAttr(primP, AttrGet(&attr));
  
  GraphRedrawNeeded();

  return EC_OK;
}
