/*
************************************************************************
*
*   ExWriteRot.c - WriteRotation command
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdio/SCCS/s.ExWriteRot.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_io.h>

#include <stdio.h>
#include <values.h>
#include <math.h>

#include <g_file.h>
#include <curr_dir.h>
#include <arg.h>
#include <data_hand.h>
#include <data_sel.h>

ErrCode
ExWriteRotation(char *cmd)
{
  GFile gf;
  DSTR fileName;
  ErrCode errCode;
  DhSpecP specP;
  Mat4 rotMat;
  float xAng, yAng, zAng;
  BOOL ok;

  fileName = DStrNew();
  errCode = ArgGetFilename(fileName, CurrDirGet(), "*.mac");
  if (errCode != EC_OK) {
    DStrFree(fileName);
    return errCode;
  }

  if (SelSpecGet(&specP, 1) == 0) {
    CipSetError("at least 1 spectrum must be selected");
    return EC_ERROR;
  }

  gf = GFileOpenNew(DStrToStr(fileName), GF_FORMAT_ASCII);
  DStrFree(fileName);
  if (gf == NULL)
    return EC_ERROR;

  DhSpecGetRotMat(specP, rotMat);
  Mat4GetAng(rotMat, &xAng, &yAng, &zAng);

  ok = GFileWriteLine(gf, "RotateInit") == GF_RES_OK;
  ok = ok && GFileWriteStr(gf, "RotateX") == GF_RES_OK;
  ok = ok && GFileWriteFLOAT32(gf, xAng * 180.0 / M_PI) == GF_RES_OK;
  ok = ok && GFileWriteNL(gf) == GF_RES_OK;
  ok = ok && GFileWriteStr(gf, "RotateY") == GF_RES_OK;
  ok = ok && GFileWriteFLOAT32(gf, yAng * 180.0 / M_PI) == GF_RES_OK;
  ok = ok && GFileWriteNL(gf) == GF_RES_OK;
  ok = ok && GFileWriteStr(gf, "RotateZ") == GF_RES_OK;
  ok = ok && GFileWriteFLOAT32(gf, zAng * 180.0 / M_PI) == GF_RES_OK;
  ok = ok && GFileWriteNL(gf) == GF_RES_OK;

  GFileClose(gf);

  if (! ok)
    return EC_ERROR;

  return EC_OK;
}
