/*
************************************************************************
*
*   ExOpen.c - Open* commands
*
*   Copyright (c) 1994-95
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdio/SCCS/s.ExOpen.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_io.h>

#include <stdlib.h>
#include <string.h>

#include <dstr.h>
#include <file_name.h>
#include <curr_dir.h>
#include <arg.h>
#include <data_hand.h>
#include <graph_draw.h>

ErrCode
ExOpen(char *cmd)
{
  SpecType type;
  char *pat;
  DSTR fileName;
  ErrCode errCode;
  DhSpecP specP;
  int dim;

  if (strcmp(cmd, "OpenBruker") == 0)
    type = ST_BRUKER;
  else
    type = ST_EASY;

  if (type == ST_BRUKER)
    pat = "*rr";
  else
    pat = "*.param";

  fileName = DStrNew();
  errCode = ArgGetFilename(fileName, CurrDirGet(), pat);
  if (errCode != EC_OK) {
    DStrFree(fileName);
    return errCode;
  }

  specP = DhSpecNew(fileName, type);
  if (specP == NULL) {
    CipSetError("could not open spec");
    DStrFree(fileName);
    return EC_ERROR;
  }

  DhSpecSetName(specP, fileName);
  DStrFree(fileName);

  dim = DhSpecGetDim(specP);
  if (dim != 2 && dim != 3) {
    CipSetError("only 2D and 3D supported");
    DhSpecDestroy(specP);
    return EC_ERROR;
  }

  DhSpecSetPropStand(specP);
  GraphSpecAdd(specP);
  GraphRedrawNeeded();

  return EC_OK;
}
