/*
************************************************************************
*
*   ExDialSpec.c - DialSpec command
*
*   Copyright (c) 1994-96
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmddial/SCCS/s.ExDialSpec.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_dial.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <break.h>
#include <pu.h>
#include <arg.h>
#include <cip.h>
#include <data_hand.h>

#define PROP_NO 3

typedef struct {
  char *label;
  char *propName;
  char *cmd;
} PropDesc;

static BOOL DialOn = FALSE;
static PuGizmo DialGizmo = NULL, ListGizmo;
static int CurrProp;
static PropRefP CurrRefP;
static int SpecNo, SpecI;
static BOOL *SpecStateA;

static PropDesc PropTab[] = {
  {"sel", PROP_SELECTED, "SelectSpec"},
  {"disp", PROP_DISPLAYED, "DefPropSpec 'displayed'"},
  {"move", PROP_MOVABLE, "DefPropSpec 'movable'"}
};

static void
countSpec(DhSpecP molP, void *clientData)
{
  SpecNo++;
}

static void
addSpec(DhSpecP molP, void *clientData)
{
  DSTR name;
  char buf[10];
  BOOL propVal;

  name = DStrNew();

  if (SpecNo > 1000)
    (void) sprintf(buf, "%4d", SpecI + 1);
  else if (SpecNo > 100)
    (void) sprintf(buf, "%3d", SpecI + 1);
  else if (SpecNo > 10)
    (void) sprintf(buf, "%2d", SpecI + 1);
  else
    (void) sprintf(buf, "%1d", SpecI + 1);
  
  DStrAssignStr(name, buf);
  DStrAppStr(name, " ");
  DStrAppDStr(name, DhSpecGetName(molP));

  propVal = DhSpecGetProp(CurrRefP, molP);
  if (! BreakCheck(10))
    PuAddListEntry(ListGizmo, DStrToStr(name), propVal);
  SpecStateA[SpecI] = propVal;

  DStrFree(name);
  SpecI++;
}

static void
selectSpecCB(PuGizmo g, char *name, void *clientData, void *callData)
{
  PuSelectCBStruc *callP = callData;
  DSTR cmd;
  BOOL isFirst;
  char buf[10];
  int num, startI, i;

  (void) sscanf(name, "%d", &num);
  SpecStateA[num - 1] = callP->onOff;

  if (! callP->last)
    return;

  cmd = DStrNew();
  DStrAssignStr(cmd, PropTab[CurrProp].cmd);

  for (i = 0; i < SpecNo; i++) {
    if (i == 0 || ! SpecStateA[i - 1])
      startI = i;
    if (SpecStateA[i] && (i == SpecNo - 1 || ! SpecStateA[i + 1])) {
      if (isFirst)
        DStrAppStr(cmd, " 'num = ");
      else
        DStrAppStr(cmd, ",");
      (void) sprintf(buf, "%d", startI + 1);
      DStrAppStr(cmd, buf);
      if (i > startI) {
        DStrAppStr(cmd, "..");
        (void) sprintf(buf, "%d", i + 1);
        DStrAppStr(cmd, buf);
      }

      isFirst = FALSE;
    }
  }

  if (isFirst)
    DStrAppStr(cmd, " '0'");
  else
    DStrAppStr(cmd, "'");

  CipExecCmd(DStrToStr(cmd));

  DStrFree(cmd);
}

static void
buildList(void)
{
  int lineNo;

  ListGizmo = PuCreateList(DialGizmo, "Spectra");
  PuSetBool(ListGizmo, PU_BC_MULT_SEL, TRUE);

  SpecNo = 0;
  DhApplySpec(PropGetRef(PROP_ALL, FALSE), countSpec, NULL);
  if (SpecNo > 0) {
    if (SpecStateA == NULL)
      SpecStateA = malloc(SpecNo * sizeof(*SpecStateA));
    else
      SpecStateA = realloc(SpecStateA, SpecNo * sizeof(*SpecStateA));
    lineNo = SpecNo;
    if (lineNo > 40)
      lineNo = 40;
  } else {
    lineNo = 1;
  }

  PuSetInt(ListGizmo, PU_IC_ENTRY_NO, lineNo);

  PuAddGizmoCB(ListGizmo, PU_CT_SELECT, selectSpecCB, NULL, NULL);
  SpecI = 0;
  BreakActivate(TRUE);
  DhApplySpec(PropGetRef(PROP_ALL, FALSE), addSpec, NULL);
  BreakActivate(FALSE);

  PuSwitchGizmo(ListGizmo, TRUE);
}

static void
updateList(void)
{
  PuDestroyGizmo(ListGizmo);
  buildList();
}

static void
selectPropCB(PuGizmo g, char *name, void *clientData, void *callData)
{
  PuSelectCBStruc *callP = callData;
  PropRefP newPropP;
  int i;

  if (! callP->onOff)
    return;

  for (i = 0; i < PROP_NO; i++)
    if (strcmp(name, PropTab[i].label) == 0)
      break;

  newPropP = PropGetRef(PropTab[i].propName, FALSE);

  if (newPropP != CurrRefP) {
    CurrRefP = newPropP;
    CurrProp = i;
    updateList();
  }
}

static void
popdownCB(PuGizmo g, char *name, void *clientData, void *callData)
{
  PuSwitchGizmo(DialGizmo, FALSE);
  DialOn = FALSE;
}

static void
updateCB(PuGizmo g, char *name, void *clientData, void *callData)
{
  updateList();
}

static void
buildDial(void)
{
  PuGizmo g;
  int i;

  CurrProp = 0;
  CurrRefP = PropGetRef(PropTab[CurrProp].propName, FALSE);

  DialGizmo = PuCreateDialog("Spectrum Dialog", 0, 0);
  PuSetBool(DialGizmo, PU_BC_PLACE_OUTSIDE, TRUE);

  g = PuCreateRadioBox(DialGizmo, "Property");
  for (i = 0; i < PROP_NO; i++)
    PuAddToggle(g, PropTab[i].label, i == 0);
  PuAddGizmoCB(g, PU_CT_SELECT, selectPropCB, NULL, NULL);
  PuSwitchGizmo(g, TRUE);

  buildList();

  PuAddGizmoCB(DialGizmo, PU_CT_OK, popdownCB, NULL, NULL);
  PuAddGizmoCB(DialGizmo, PU_CT_RESET, updateCB, NULL, NULL);
}

ErrCode
ExDialSpec(char *cmd)
{
  ArgDescr arg;
  EnumEntryDescr enumEntry[2];
  ErrCode errCode;

  arg.type = AT_ENUM;

  ArgInit(&arg, 1);

  arg.prompt = "Spectrum Dialog";
  arg.u.enumD.entryP = enumEntry;
  arg.u.enumD.n = 2;

  enumEntry[0].str = "off";
  enumEntry[1].str = "on";

  enumEntry[0].onOff = DialOn;
  enumEntry[1].onOff = ! DialOn;
  if (DialOn)
    arg.v.intVal = 0;
  else
    arg.v.intVal = 1;

  errCode = ArgGet(&arg, 1);
  if (errCode != EC_OK) {
    ArgCleanup(&arg, 1);
    return errCode;
  }

  DialOn = (arg.v.intVal == 1);

  ArgCleanup(&arg, 1);

  if (DialOn) {
    if (DialGizmo == NULL)
      buildDial();
    PuSwitchGizmo(DialGizmo, TRUE);
  } else {
    if (DialGizmo != NULL)
      PuSwitchGizmo(DialGizmo, FALSE);
  }

  return EC_OK;
}
