/*
************************************************************************
*
*   ExDialSelect.c - DialSelect command
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmddial/SCCS/s.ExDialSelect.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_dial.h>

#include <stdio.h>
#include <string.h>

#include <pu.h>
#include <arg.h>
#include <cip.h>

#define ENT_NO 3

static BOOL DialOn = FALSE;
static PuGizmo DialGizmo = NULL;

static char *SelectNames[] = {
  "Spec",
  "Peak",
  "Prim"
};

static DSTR ExprTab[ENT_NO];

static int
getCmdInd(char *cmd)
{
  int i;

  for (i = 0; i < ENT_NO; i++)
    if (strcmp(cmd, SelectNames[i]) == 0)
      return i;

  return 0;
}

static void
execCmd(char *name)
{
  int cmdInd = getCmdInd(name);
  DSTR cmdStr;

  cmdStr = DStrNew();
  DStrAssignStr(cmdStr, "Select");
  DStrAppStr(cmdStr, name);
  DStrAppStr(cmdStr, " '");
  if (ExprTab[cmdInd] != NULL)
    DStrAppDStr(cmdStr, ExprTab[cmdInd]);
  DStrAppStr(cmdStr, "'");

  (void) CipExecCmd(DStrToStr(cmdStr));

  DStrFree(cmdStr);
}

static void
cmdCB(PuGizmo g, char *name, void *clientData, void *callData)
{
  execCmd(name);
}

static void
editCB(PuGizmo g, char *name, void *clientData, void *callData)
{
  char *cmd = clientData;
  PuTextCBStruc *callP = callData;
  int cmdInd = getCmdInd(cmd);

  if (ExprTab[cmdInd] == NULL)
    ExprTab[cmdInd] = DStrNew();

  DStrAssignStr(ExprTab[cmdInd], callP->newText);
}

static void
activateCB(PuGizmo g, char *name, void *clientData, void *callData)
{
  execCmd(clientData);
}

static void
popdownCB(PuGizmo g, char *name, void *clientData, void *callData)
{
  PuSwitchGizmo(DialGizmo, FALSE);
  DialOn = FALSE;
}

static void
buildDial(void)
{
  PuGizmo g;
  PuConstraints con;
  int i;

  DialGizmo = PuCreateDialog("Selection Dialog", 6, ENT_NO);
  PuSetBool(DialGizmo, PU_BC_PLACE_OUTSIDE, TRUE);

  for (i = 0; i < ENT_NO; i++) {
    con.y = i;
    con.h = 1;

    g = PuCreateButton(DialGizmo, SelectNames[i]);
    con.x = 0;
    con.w = 1;
    PuSetConstraints(g, con);
    PuAddGizmoCB(g, PU_CT_ACTIVATE, cmdCB, NULL, NULL);
    PuSwitchGizmo(g, TRUE);

    g = PuCreateTextField(DialGizmo, "", "");
    con.x = 1;
    con.w = 5;
    PuSetConstraints(g, con);
    PuAddGizmoCB(g, PU_CT_MODIFY, editCB, SelectNames[i], NULL);
    PuAddGizmoCB(g, PU_CT_ACTIVATE, activateCB, SelectNames[i], NULL);
    PuSwitchGizmo(g, TRUE);
  }

  PuAddGizmoCB(DialGizmo, PU_CT_OK, popdownCB, NULL, NULL);
}

ErrCode
ExDialSelect(char *cmd)
{
  ArgDescr arg;
  EnumEntryDescr enumEntry[2];
  ErrCode errCode;

  arg.type = AT_ENUM;

  ArgInit(&arg, 1);

  arg.prompt = "Selection Dialog";
  arg.u.enumD.entryP = enumEntry;
  arg.u.enumD.n = 2;

  enumEntry[0].str = "off";
  enumEntry[1].str = "on";

  enumEntry[0].onOff = DialOn;
  enumEntry[1].onOff = ! DialOn;
  if (DialOn)
    arg.v.intVal = 0;
  else
    arg.v.intVal = 1;

  errCode = ArgGet(&arg, 1);
  if (errCode != EC_OK) {
    ArgCleanup(&arg, 1);
    return errCode;
  }

  DialOn = (arg.v.intVal == 1);

  ArgCleanup(&arg, 1);

  if (DialOn) {
    if (DialGizmo == NULL)
      buildDial();
    PuSwitchGizmo(DialGizmo, TRUE);
  } else {
    if (DialGizmo != NULL)
      PuSwitchGizmo(DialGizmo, FALSE);
  }

  return EC_OK;
}
