/*
************************************************************************
*
*   ExStyle.c - display style setting commands
*
*   Copyright (c) 1994-96
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdattr/SCCS/s.ExStyle.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_attr.h>

#include <stdio.h>

#include <arg.h>
#include <data_hand.h>
#include <attr_struc.h>
#include <attr_mng.h>
#include <graph_draw.h>

static int ChoiceSpec = 1, ChoicePeak = 0;
static PropRefP VisibleRefP;

static void
setSpecStyle(DhSpecP specP, void *clientData)
{
  SpecStyle style = *(SpecStyle *) clientData;
  AttrP attrP;
  struct AttrS attr;

  attrP = DhSpecGetAttr(specP);
  AttrCopy(&attr, attrP);
  AttrReturn(attrP);
  attr.specStyle = style;
  if (style == SS_SURFACE)
    attr.shadeModel = SHADE_DEFAULT;
  else
    attr.shadeModel = -1;
  DhSpecSetAttr(specP, AttrGet(&attr));

  DhSpecSetProp(VisibleRefP, specP, style != SS_INVISIBLE);
}

static void
setPeakStyle(DhPeakP peakP, void *clientData)
{
  PeakStyle style = *(PeakStyle *) clientData;
  AttrP attrP;
  struct AttrS attr;

  attrP = DhPeakGetAttr(peakP);
  AttrCopy(&attr, attrP);
  AttrReturn(attrP);
  attr.peakStyle = style;
  if (style == PS_CIRCLE)
    attr.shadeModel = SHADE_DEFAULT;
  else
    attr.shadeModel = -1;
  DhPeakSetAttr(peakP, AttrGet(&attr));

  DhPeakSetProp(VisibleRefP, peakP, style != PS_INVISIBLE);
}

#define ARG_NUM 1

ErrCode
ExStyleSpec(char *cmd)
{
  ArgDescr arg[ARG_NUM];
  EnumEntryDescr enumEntry[4];
  ErrCode errCode;
  SpecStyle style;

  arg[0].type = AT_ENUM;

  ArgInit(arg, ARG_NUM);

  enumEntry[0].str = "invisible";
  enumEntry[0].onOff = FALSE;
  enumEntry[1].str = "grid";
  enumEntry[1].onOff = FALSE;
  enumEntry[2].str = "surface";
  enumEntry[2].onOff = FALSE;
  enumEntry[3].str = "contour";
  enumEntry[3].onOff = FALSE;

  enumEntry[ChoiceSpec].onOff = TRUE;

  arg[0].prompt = "Spec Style";
  arg[0].u.enumD.entryP = enumEntry;
  arg[0].u.enumD.n = 4;
  arg[0].v.intVal = ChoiceSpec;

  errCode = ArgGet(arg, ARG_NUM);
  if (errCode != EC_OK) {
    ArgCleanup(arg, ARG_NUM);
    return errCode;
  }

  ChoiceSpec = arg[0].v.intVal;
  ArgCleanup(arg, ARG_NUM);

  if (ChoiceSpec == 0)
    style = SS_INVISIBLE;
  else if (ChoiceSpec == 1)
    style = SS_GRID;
  else if (ChoiceSpec == 2)
    style = SS_SURFACE;
  else
    style = SS_CONTOUR;

  VisibleRefP = PropGetRef(PROP_VISIBLE, FALSE);
  DhApplySpec(PropGetRef(PROP_SELECTED, FALSE), setSpecStyle, &style);

  GraphSpecChanged(PROP_SELECTED);
  GraphRedrawNeeded();

  return EC_OK;
}

ErrCode
ExStylePeak(char *cmd)
{
  ArgDescr arg[ARG_NUM];
  EnumEntryDescr enumEntry[3];
  ErrCode errCode;
  PeakStyle style;

  arg[0].type = AT_ENUM;

  ArgInit(arg, ARG_NUM);

  enumEntry[0].str = "invisible";
  enumEntry[0].onOff = FALSE;
  enumEntry[1].str = "circle";
  enumEntry[1].onOff = FALSE;
  enumEntry[2].str = "cross";
  enumEntry[2].onOff = FALSE;

  enumEntry[ChoicePeak].onOff = TRUE;

  arg[0].prompt = "Peak Style";
  arg[0].u.enumD.entryP = enumEntry;
  arg[0].u.enumD.n = 3;
  arg[0].v.intVal = ChoicePeak;

  errCode = ArgGet(arg, ARG_NUM);
  if (errCode != EC_OK) {
    ArgCleanup(arg, ARG_NUM);
    return errCode;
  }

  ChoicePeak = arg[0].v.intVal;
  ArgCleanup(arg, ARG_NUM);

  if (ChoicePeak == 0)
    style = PS_INVISIBLE;
  else if (ChoicePeak == 1)
    style = PS_CIRCLE;
  else
    style = PS_CROSS;

  VisibleRefP = PropGetRef(PROP_VISIBLE, FALSE);
  DhApplyPeak(PropGetRef(PROP_SELECTED, FALSE), setPeakStyle, &style);

  GraphSpecChanged(PROP_SELECTED);
  GraphRedrawNeeded();

  return EC_OK;
}
