/*
************************************************************************
*
*   ExShade.c - shade commands
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdattr/SCCS/s.ExShade.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_attr.h>

#include <stdio.h>
#include <string.h>

#include <arg.h>
#include <data_hand.h>
#include <prim_hand.h>
#include <attr_struc.h>
#include <attr_mng.h>
#include <graph_draw.h>

static short ShadeModel = SHADE_DEFAULT;

static AttrP
changeShade(AttrP attrP)
{
  struct AttrS attr;

  AttrCopy(&attr, attrP);
  AttrReturn(attrP);
  attr.shadeModel = ShadeModel;
  return AttrGet(&attr);
}

static void
setSpecShade(DhSpecP specP, void *clientData)
{
  DhSpecSetAttr(specP, changeShade(DhSpecGetAttr(specP)));
}

static void
setPeakShade(DhPeakP peakP, void *clientData)
{
  DhPeakSetAttr(peakP, changeShade(DhPeakGetAttr(peakP)));
}

static void
setPrimShade(PrimObjP primP, void *clientData)
{
  PrimSetAttr(primP, changeShade(PrimGetAttr(primP)));
}

#define ARG_NUM 1

ErrCode
ExShade(char *cmd)
{
  DataEntityType entType;
  ArgDescr arg[ARG_NUM];
  EnumEntryDescr enumEntry[6];
  ErrCode errCode;
  PropRefP refP;

  if (strcmp(cmd, "ShadeSpec") == 0)
    entType = DE_SPEC;
  else if (strcmp(cmd, "ShadePeak") == 0)
    entType = DE_PEAK;
  else
    entType = DE_PRIM;

  arg[0].type = AT_ENUM;

  ArgInit(arg, ARG_NUM);

  enumEntry[0].str = "none";
  enumEntry[0].onOff = FALSE;
  enumEntry[1].str = "flat";
  enumEntry[1].onOff = FALSE;
  enumEntry[2].str = "gouraud";
  enumEntry[2].onOff = FALSE;
  enumEntry[3].str = "phong";
  enumEntry[3].onOff = FALSE;
  enumEntry[4].str = "dots";
  enumEntry[4].onOff = FALSE;
  enumEntry[5].str = "lines";
  enumEntry[5].onOff = FALSE;

  enumEntry[ShadeModel + 1].onOff = TRUE;

  arg[0].prompt = "Shading";
  arg[0].u.enumD.entryP = enumEntry;
  arg[0].u.enumD.n = 6;
  arg[0].v.intVal = ShadeModel + 1;

  errCode = ArgGet(arg, ARG_NUM);
  if (errCode != EC_OK) {
    ArgCleanup(arg, ARG_NUM);
    return errCode;
  }

  ShadeModel = arg[0].v.intVal - 1;
  ArgCleanup(arg, ARG_NUM);

  refP = PropGetRef(PROP_SELECTED, FALSE);

  switch (entType) {
    case DE_SPEC:
      DhApplySpec(refP, setSpecShade, NULL);
      break;
    case DE_PEAK:
      DhApplyPeak(refP, setPeakShade, NULL);
      break;
    case DE_PRIM:
      PrimApply(PT_ALL, refP, setPrimShade, NULL);
      break;
  }

  GraphSpecChanged(PROP_SELECTED);
  GraphRedrawNeeded();

  return EC_OK;
}
