/*
************************************************************************
*
*   ExLabel.c - labelling commands
*
*   Copyright (c) 1995
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdattr/SCCS/s.ExLabel.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_attr.h>

#include <stdio.h>
#include <string.h>
#include <memory.h>

#include <arg.h>
#include <data_hand.h>
#include <attr_struc.h>
#include <attr_mng.h>
#include <graph_draw.h>

static char PeakFormat[LABEL_FORMAT_SIZE] = "";

static void
setPeakLabel(DhPeakP peakP, void *clientData)
{
  AttrP attrP;
  struct AttrS attr;

  attrP = DhPeakGetAttr(peakP);
  AttrCopy(&attr, attrP);
  AttrReturn(attrP);
  (void) memcpy(attr.labelFormat, PeakFormat, sizeof(PeakFormat));
  DhPeakSetAttr(peakP, AttrGet(&attr));
}

#define ARG_NUM 1

ErrCode
ExLabelPeak(char *cmd)
{
  ArgDescr arg[ARG_NUM];
  ErrCode errCode;
  int len;

  arg[0].type = AT_STR;

  ArgInit(arg, ARG_NUM);

  arg[0].prompt = "Label Format";

  errCode = ArgGet(arg, ARG_NUM);
  if (errCode != EC_OK) {
    ArgCleanup(arg, ARG_NUM);
    return errCode;
  }

  len = DStrLen(arg[0].v.strVal);
  if (len >= sizeof(PeakFormat))
    len = sizeof(PeakFormat) - 1;

  (void) memcpy(PeakFormat, DStrToStr(arg[0].v.strVal), len);
  (void) memset(PeakFormat + len, 0, sizeof(PeakFormat) - len);

  ArgCleanup(arg, ARG_NUM);

  DhApplyPeak(PropGetRef(PROP_SELECTED, FALSE), setPeakLabel, NULL);
  GraphSpecChanged(PROP_SELECTED);

  GraphRedrawNeeded();

  return EC_OK;
}
