/*
************************************************************************
*
*   ExAngle.c - angle setting commands
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/src/cmdattr/SCCS/s.ExAngle.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <cmd_attr.h>

#include <string.h>

#include <arg.h>
#include <data_hand.h>
#include <prim_hand.h>
#include <attr_struc.h>
#include <attr_mng.h>
#include <graph_draw.h>

typedef struct {
  ExprP angleExprP;
  float angle;
} AngleDescr;

static float CurrAngle = 0.0;

static void
evalAngle(void *entP, AngleDescr *angleP)
{
  ExprRes exprRes;

  ExprEval(entP, angleP->angleExprP, &exprRes);
  if (exprRes.resType == ER_INT)
    angleP->angle = (float) exprRes.u.intVal;
  else
    angleP->angle = exprRes.u.floatVal;
}

static AttrP
changeAngle(AttrP attrP, AngleDescr *angleP)
{
  struct AttrS attr;

  if (angleP->angle < 0.0)
    angleP->angle = 0.0;
  else if (angleP->angle > 6.0)
    angleP->angle = 6.0;

  CurrAngle = angleP->angle;

  AttrCopy(&attr, attrP);
  AttrReturn(attrP);
  attr.angle = angleP->angle;
  return AttrGet(&attr);
}

static void
peakAngle(DhPeakP peakP, void *clientData)
{
  evalAngle(peakP, clientData);
  DhPeakSetAttr(peakP, changeAngle(DhPeakGetAttr(peakP), clientData));
}

#define ARG_NUM 1

ErrCode
ExAngle(char *cmd)
{
  DataEntityType entType;
  ArgDescr arg[ARG_NUM];
  ErrCode errCode;
  AngleDescr angleDescr;
  PropRefP refP;

  entType = DE_PEAK;

  arg[0].type = AT_DOUBLE;

  ArgInit(arg, ARG_NUM);

  arg[0].prompt = "Angle";
  arg[0].entType = entType;
  arg[0].v.doubleVal = CurrAngle;

  errCode = ArgGet(arg, ARG_NUM);
  if (errCode != EC_OK) {
    ArgCleanup(arg, ARG_NUM);
    return errCode;
  }

  angleDescr.angleExprP = arg[0].v.exprP;

  refP = PropGetRef(PROP_SELECTED, FALSE);

  DhApplyPeak(refP, peakAngle, &angleDescr);

  ArgCleanup(arg, ARG_NUM);

  GraphSpecChanged(PROP_SELECTED);
  GraphRedrawNeeded();

  return EC_OK;
}
