/*
************************************************************************
*
*   X11Circle.c - X11 circle drawing
*
*   Copyright (c) 1994
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 94/08/11
*   Pathname of SCCS file     : /sgiext/molmol/sg/src/x11/SCCS/s.X11Circle.c
*   SCCS identification       : 1.2
*
************************************************************************
*/

#include "x11_circle.h"

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <X11/Xlib.h>

#include <sg_map.h>
#include "x11_access.h"

void
SgX11DrawCircle(float x[2], float r)
{
  float xm[2];

  SgVpMapPoint(xm, x);
  r = SgVpMapSize(r);

  XDrawArc(X11GetDisplay(), X11GetDrawable(), X11GetGC(),
      (int) (xm[0] - r), (int) (xm[1] - r),
      (unsigned int) (2.0 * r), (unsigned int) (2.0 * r),
      0, 360 * 64);
}

void
SgX11DrawDisc(float x[2], float r)
{
  float xm[2];

  SgVpMapPoint(xm, x);
  r = SgVpMapSize(r);

  XFillArc(X11GetDisplay(), X11GetDrawable(), X11GetGC(),
      (int) (xm[0] - r), (int) (xm[1] - r),
      (unsigned int) (2.0 * r), (unsigned int) (2.0 * r),
      0, 360 * 64);
}
