/*
************************************************************************
*
*   VRMLText.c - VRML text drawing
*
*   Copyright (c) 1996
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/07/21
*   Pathname of SCCS file     : /sgiext/molmol/sg/src/vrml/SCCS/s.VRMLText.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include "vrml_text.h"

#include <stdlib.h>
#include <string.h>

#include <sg_map.h>
#include <sg_plot.h>
#include "vrml_util.h"
#include "vrml_color.h"

static float CurrSize2D, CurrSize;

static void
plotText(float x[3], float fullSize, char *str)
{
  char *cleanStr;
  int i;

  cleanStr = malloc(strlen(str) + 1);

  free(cleanStr);

  i = 0;
  while (*str != '\0') {
    if (*str != '_' && *str != '^' && *str != '{' && *str != '}')
      cleanStr[i++] = *str;

    str++;
  }
  cleanStr[i] = '\0';

  SgPlotOutputStr("Separator {\n");
  VRMLPlotColor();

  SgPlotOutputStr("FontStyle {\n");
  SgPlotOutputStr("size ");
  SgPlotOutputFloat(fullSize);
  SgPlotOutputStr("\n");
  SgPlotOutputStr("family SANS\n");
  SgPlotOutputStr("}\n");

  SgPlotOutputStr("AsciiText {\n");
  SgPlotOutputStr("string ");
  SgPlotOutputStr(cleanStr);
  SgPlotOutputStr("\n");
  SgPlotOutputStr("}\n");

  SgPlotOutputStr("}\n");
}

void
SgVRMLDrawAnnot2D(float x[2], char *str)
{
  float xm[3];

  VRMLMap2D(xm, x);
  plotText(xm, CurrSize2D, str);
}

void
SgVRMLDrawText2D(float x[2], char *str)
{
  float xm[3];

  VRMLMap2D(xm, x);
  plotText(xm, CurrSize2D, str);
}

void
SgVRMLDrawAnnot(float x[3], char *str)
{
  float xm[3];

  SgMapModelPoint(xm, x);
  plotText(xm, CurrSize, str);
}

void
SgVRMLDrawText(float x[3], char *str)
{
  float xm[3];

  SgMapModelPoint(xm, x);
  plotText(xm, CurrSize, str);
}

static float
mapSize(float size)
{
  float xm[3], x[2];

  x[0] = 0.0;
  x[1] = size;

  VRMLMap2D(xm, x);

  return xm[1];
}

void
SgVRMLSetFontSize2D(float size)
{
  CurrSize2D = mapSize(size);
}

void
SgVRMLSetFontSize(float size)
{
  CurrSize = mapSize(size);
}
