/*
************************************************************************
*
*   VRMLLine.c - VRML line drawing
*
*   Copyright (c) 1996
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/07/21
*   Pathname of SCCS file     : /sgiext/molmol/sg/src/vrml/SCCS/s.VRMLLine.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include "vrml_line.h"

#include <sg_map.h>
#include <sg_plot.h>
#include "vrml_util.h"
#include "vrml_color.h"

static void
plotLine(float x0[3], float x1[3])
{
  SgPlotOutputStr("Separator {\n");
  VRMLPlotColor();

  SgPlotOutputStr("Coordinate3 {\n");
  SgPlotOutputStr("point [");
  VRMLPlotVect(x0);
  SgPlotOutputStr(", ");
  VRMLPlotVect(x1);
  SgPlotOutputStr("]\n");
  SgPlotOutputStr("}\n");

  SgPlotOutputStr("IndexedLineSet {\n");
  SgPlotOutputStr("coordIndex [0, 1]\n");
  SgPlotOutputStr("}\n");

  SgPlotOutputStr("}\n");
}

void
SgVRMLDrawLine2D(float x0[2], float x1[2])
{
  float x0m[3], x1m[3];

  VRMLMap2D(x0m, x0);
  VRMLMap2D(x1m, x1);

  plotLine(x0m, x1m);
}

void
SgVRMLDrawPolyline2D(float x[][2], int n)
{
  float xm[3];
  int i;

  SgPlotOutputStr("Separator {\n");
  VRMLPlotColor();

  SgPlotOutputStr("Coordinate3 {\n");
  SgPlotOutputStr("point [\n");

  for (i = 0; i < n; i++) {
    VRMLMap2D(xm, x[i]);
    VRMLPlotVect(xm);
    SgPlotOutputStr(",\n");
  }

  SgPlotOutputStr("]\n");
  SgPlotOutputStr("}\n");

  SgPlotOutputStr("IndexedLineSet {\n");
  SgPlotOutputStr("coordIndex [");
  for (i = 0; i < n; i++) {
    SgPlotOutputInt(i);
    SgPlotOutputStr(", ");
  }
  SgPlotOutputStr("]\n");
  SgPlotOutputStr("}\n");

  SgPlotOutputStr("}\n");
}

void
SgVRMLDrawLine(float x0[3], float x1[3])
{
  float x0m[3], x1m[3];

  SgMapModelPoint(x0m, x0);
  SgMapModelPoint(x1m, x1);

  plotLine(x0m, x1m);
}

void
SgVRMLDrawPolyline(float x[][3], int n)
{
  float xm[3];
  int i;

  SgPlotOutputStr("Separator {\n");
  VRMLPlotColor();

  SgPlotOutputStr("Coordinate3 {\n");
  SgPlotOutputStr("point [\n");

  for (i = 0; i < n; i++) {
    SgMapModelPoint(xm, x[i]);
    VRMLPlotVect(xm);
    SgPlotOutputStr(",\n");
  }

  SgPlotOutputStr("]\n");
  SgPlotOutputStr("}\n");

  SgPlotOutputStr("IndexedLineSet {\n");
  SgPlotOutputStr("coordIndex [");
  for (i = 0; i < n; i++) {
    SgPlotOutputInt(i);
    SgPlotOutputStr(", ");
  }
  SgPlotOutputStr("]\n");
  SgPlotOutputStr("}\n");

  SgPlotOutputStr("}\n");
}
