/*
************************************************************************
*
*   SgPick.c - Sg picking
*
*   Copyright (c) 1994
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 95/11/21
*   Pathname of SCCS file     : /sgiext/molmol/sg/src/sgdev/SCCS/s.SgPick.c
*   SCCS identification       : 1.5
*
************************************************************************
*/

#include <sg_dev.h>
#include <sg_pick.h>

#include <stdio.h>
#include <values.h>
#include <math.h>

#include <sg.h>
#include "sg_name.h"
#include "sg_set.h"
#include "sg_view.h"

static SgDev *OldDevP;
static char *OldDevName;
static float PointX, PointY;
static void *CurrTypeP, *CurrObjP;
static void *MinTypeP, *MinObjP;
static float MinDist, MinZ;
static int MinCloseInd;

void
SgStartPick(float x, float y)
{
  float vpx, vpy, vpw, vph;

  SgGetViewport(&vpx, &vpy, &vpw, &vph);
  PointX = x;
  PointY = y;

  MinDist = MAXFLOAT;
  MinZ = MAXFLOAT;
  CurrTypeP = NULL;
  CurrObjP = NULL;
  MinTypeP = NULL;
  MinObjP = NULL;
  MinCloseInd = 0;

  OldDevP = CurrSgDevP;
  OldDevName = SgGetDeviceName();
  SgSetDevice("Pick");
  SgInit(NULL, 0);
  SgUpdateViewport();
  SgUpdateView();
}

void
SgEndPick(void **typePP, void **objPP, int *closeIndP, float *distP)
{
  (void) SgCleanup();
  CurrSgDevP = OldDevP;
  SgSetDeviceName(OldDevName);
  SgSetAttr();

  if (typePP != NULL)
    *typePP = MinTypeP;

  if (objPP != NULL)
    *objPP = MinObjP;

  if (closeIndP != NULL)
    *closeIndP = MinCloseInd;

  if (distP != NULL)
    *distP = sqrt(MinDist);
}

void
SgPickGetPoint(float x[2])
{
  x[0] = PointX;
  x[1] = PointY;
}

void
SgSetPickObj(void *typeP, void *objP)
{
  CurrTypeP = typeP;
  CurrObjP = objP;
}

void
SgPickDist(float d, float z, int closeInd)
{
  if (d <= MinDist && (d > 0.0 || z <= MinZ) && CurrObjP != NULL) {
    MinDist = d;
    if (d == 0.0)
      MinZ = z;
    MinTypeP = CurrTypeP;
    MinObjP = CurrObjP;
    MinCloseInd = closeInd;
  }
}
