/*
************************************************************************
*
*   SgBuff.c - Sg double buffering
*
*   Copyright (c) 1994
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 95/02/05
*   Pathname of SCCS file     : /sgiext/molmol/sg/src/sgdev/SCCS/s.SgBuff.c
*   SCCS identification       : 1.3
*
************************************************************************
*/

#include <sg_dev.h>

static BOOL DoubleBuffOn = FALSE;

void
SgSetDoubleBuffer(BOOL onOff)
{
  DoubleBuffOn = onOff;
}

BOOL
SgGetDoubleBuffer(void)
{
  return DoubleBuffOn;
}

void
SgSetBuffer(SgBuffer buf)
{
  CurrSgDevP->setBuffer(buf);
}

void
SgEndFrame(void)
{
  CurrSgDevP->calcHidden();
  CurrSgDevP->endFrame();
}

BOOL
SgRefresh(void)
{
  return CurrSgDevP->refresh();
}
