/*
************************************************************************
*
*   POVUtil.c - POV utility functions
*
*   Copyright (c) 1994
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 94/11/15
*   Pathname of SCCS file     : /local/home/kor/molmol/sg/src/pov/SCCS/s.POVUtil.c
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include "pov_util.h"

#include <sg_get.h>
#include <sg_plot.h>

static float Fact;

void
POVInit2D(void)
{
  Fact = SgGetOrthoHeight();
}

void
POVMap2D(float xOut[3], float xIn[2])
{
  xOut[0] = xIn[0] * Fact;
  xOut[1] = xIn[1] * Fact;
  xOut[2] = 0.0;
}

void
POVPlotVect(float x[3])
{
  SgPlotOutputStr("<");
  SgPlotOutputFloat(x[0]);
  SgPlotOutputStr(", ");
  SgPlotOutputFloat(x[1]);
  SgPlotOutputStr(", ");
  SgPlotOutputFloat(x[2]);
  SgPlotOutputStr(">");
}
