/*
************************************************************************
*
*   POVInit.c - init POV device
*
*   Copyright (c) 1994-97
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 97/09/26
*   Pathname of SCCS file     : /files/kor/molmol/sg/src/pov/SCCS/s.POVInit.c
*   SCCS identification       : 1.6
*
************************************************************************
*/

#include "pov_init.h"

#include <sg_plot.h>
#include "pov_util.h"
#include "pov_view.h"

SgRes
SgPOVInit(int *argcP, char *argv[])
{
  float gamma;

  SgPlotOutputStr("#include \"colors.inc\"\n");
  SgPlotOutputStr("#include \"textures.inc\"\n");
  SgPlotOutputStr("\n");

  gamma = SgPlotGetGamma();

  if (gamma != 1.0) {
    SgPlotOutputStr("global_settings {assumed_gamma ");
    SgPlotOutputFloat(gamma);
    SgPlotOutputStr("}\n");
  }

  POVInit2D();
  POVInitView();

  return SG_RES_OK;
}

SgRes
SgPOVCleanup(void)
{
  return SG_RES_OK;
}
