/*
************************************************************************
*
*   io_dev.h - structure for I/O device
*
*   Copyright (c) 1994-96
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/include/SCCS/s.io_dev.h
*   SCCS identification       : 1.1
*
************************************************************************
*/

#include <io.h>

typedef IORes (*IOInitF) (char *, int *, char *[]);
typedef IORes (*IOCleanupF) (void);
typedef IORes (*IOSetWindowF) (PuWindow);
typedef void (*IOEndFrameF) (void);
typedef IORes (*IOStartDumpF) (char *, char *,
    SgPlotOrient, int, int, int, float);
typedef IORes (*IOEndDumpF) (void);

typedef struct {
  IOInitF init;
  IOCleanupF cleanup;
  IOSetWindowF setWindow;
  IOEndFrameF endFrame;
  IOStartDumpF startDump;
  IOEndDumpF endDump;
  char *puDevName;
  char *sgDevName;
} IODev;

extern IODev *CurrIODevP;
