/*
************************************************************************
*
*   data_sel.h - utility functions for selection
*
*   Copyright (c) 1994
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/include/SCCS/s.data_sel.h
*   SCCS identification       : 1.1
*
************************************************************************
*/

#ifndef _DATA_DEL_H_
#define _DATA_DEL_H_

#include <data_ent.h>
#include <data_hand.h>

typedef enum {
  SK_ADD,
  SK_REMOVE,
  SK_REPLACE
} SelKind;

typedef void (* SelCB) (DataEntityType, void *, SelKind);

extern void SelAddCB(SelCB);

extern int SelSpecGet(DhSpecP[], int);

extern int SelPeakGet(DhPeakP[], int);

extern void SelSpec(DhSpecP, SelKind);

extern void SelPeak(DhPeakP, SelKind);

extern void DeselAllSpec(void);

extern void DeselAllPeak(void);

#endif  /* _DATA_DEL_H_ */
