#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <values.h>

#include <app/reg_shape.h>

#define SIZE0 2
#define SIZE1 2

static void
fillTestReg(AppRegionDataP regDataP)
{
  float *v;
  int i;

  regDataP->dimensionNo = 2;
  regDataP->dataType = ADT_FLT32;

  regDataP->rangeA[0][0] = 0;
  regDataP->rangeA[0][1] = 1;
  regDataP->rangeA[1][0] = 0;
  regDataP->rangeA[1][1] = 1;

  regDataP->subRangeA[0][0] = 0;
  regDataP->subRangeA[0][1] = 1;
  regDataP->subRangeA[1][0] = 0;
  regDataP->subRangeA[1][1] = 1;

  regDataP->dataA = malloc(SIZE0 * SIZE1 * sizeof(float));
  regDataP->validA = malloc(SIZE0 * SIZE1 * sizeof(*regDataP->validA));

  v = regDataP->dataA;

  v[0] = 2.0; v[1] = 1.0;
  v[2] = 1.0; v[3] = 1.0;

  for (i = 0; i < SIZE0 * SIZE1; i++)
    regDataP->validA[i] = TRUE;

  regDataP->maxAmplitude = 2.0;
  regDataP->noiseMagnitudeMax = 0.0;
}

static void
freeReg(AppRegionDataP regDataP)
{
  free(regDataP->dataA);
  free(regDataP->validA);
}

static void
printShape(AppShapeP shapeP)
{
  int i;

  AppShapeCalcPar(shapeP);

  for (i = 0; i < shapeP->valueNo; i++)
    (void) printf("%7.4f ", shapeP->valueA[i]);
  (void) printf("\n");
}

static void
testShape(void)
{
  struct AppRegionDataS regDataS;
  struct AppShapeS shapeA[2];
  float amp, err;

  (void) printf("\nCalcShapes\n");

  fillTestReg(&regDataS);
  AppCalcShapes(&regDataS, NULL, shapeA, &amp, &err);
  freeReg(&regDataS);

  printShape(&shapeA[0]);
  printShape(&shapeA[1]);
  (void) printf("amp: %7.4f   err: %7.4f\n", amp, err);

  AppShapeDestroy(&shapeA[0]);
  AppShapeDestroy(&shapeA[1]);
}

int
main(int argc, char *argv[])
{
  testShape();

  return 0;
}
