/*
************************************************************************
*
*   Memory.c - I/O of spectra that are in memory already
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/app/src/specio/SCCS/s.Memory.c
*   SCCS identification       : 1.2
*
************************************************************************
*/

#include <specio/memory.h>

#include <stdio.h>
#include <string.h>

#include <linlist.h>

typedef struct {
  AppSpectrumP specP;
  int dim;
  int sizeA[APP_MAX_DIM];
  AppDataP dataA;
} SpecDescr;

static LINLIST SpecList = NULL;

static void
readMemory(void *clientData, AppDataRange rangeA[], AppDataP dataA)
{
  SpecDescr *descrP = clientData;
  int coord[APP_MAX_DIM];
  int rowLen;
  int subInd, ind, i;

  rowLen = rangeA[0][1] - rangeA[0][0] + 1;

  subInd = 0;
  for (i = 0; i < descrP->dim; i++)
    coord[i] = rangeA[i][0];

  for (;;) {
    ind = 0;
    for (i = descrP->dim - 1; i >= 0; i--)
      ind = ind * descrP->sizeA[i] + coord[i];
    
    (void) memcpy((char *) dataA + 4 * subInd,
	(char *) descrP->dataA + 4 * ind, 4 * rowLen);

    for (i = 1; i < descrP->dim; i++) {
      if (coord[i] == rangeA[i][1]) {
	coord[i] = rangeA[i][0];
      } else {
	coord[i]++;
	break;
      }
    }

    if (i == descrP->dim)
      break;

    subInd += rowLen;
  }
}

AppSpectrumP
SpecIOMemoryOpen(void *dataA, int dim, int sizeA[], float offsA[], float swA[],
    AppDataType type)
{
  SpecDescr descr, *descrP;
  int i;

  if (SpecList == NULL)
    SpecList = ListOpen(sizeof(SpecDescr));
  
  descr.dim = dim;
  for (i = 0; i < dim; i++)
    descr.sizeA[i] = sizeA[i];
  descr.dataA = dataA;

  descrP = ListInsertLast(SpecList, &descr);

  descrP->specP = AppOpenSpectrum(descr.dim, sizeA, offsA, swA,
      type, readMemory, descrP);

  return descrP->specP;
}

void
SpecIOMemoryClose(AppSpectrumP specP)
{
  SpecDescr *descrP;

  AppCloseSpectrum(specP);

  descrP = ListFirst(SpecList);
  while (descrP != NULL) {
    if (descrP->specP == specP) {
      ListRemove(SpecList, descrP);
      break;
    }
    descrP = ListNext(SpecList, descrP);
  }
}
