/*
************************************************************************
*
*   ByteSwap.c - byte swapping
*
*   Copyright (c) 1989-96
*   BRUKER INSTRUMENTS, INC. / SPECTROSPIN AG
*   All Rights Reserved
*
*   Date of last modification   : 96/09/13
*   Pathname of SCCS file       : /sgiext/autopsy/app/src/ndio/SCCS/s.ByteSwap.c
*   SCCS identification         : 1.1
*
*   Modifications :
*   <NAME>      <DATE>  <COMMENTS>
*   gegu        920701  extracted from BinConv.c added 2byte and 8byte
*                       reversing
*
************************************************************************
*/

#include "byte_swap.h"

#include <ndio/mach_types.h>

/**********************************************************************/
/*
  Macro to reverse byte order in a 2 byte integer,
  parameters are optimized for use in loop unrolling.

    p = char pointer to start of 16 bit integer
    i = char offset (constant) into 16bit integer block
    t = temporary int variable for reversing bytes
*/
#define REVERSE16(p,t, i) \
  t = p[0+i]; p[0+i] = p[1+i]; p[1+i] = t


/**********************************************************************/
/*
  Macro to reverse byte order in a 4 byte integer,
  parameters are optimized for use in loop unrolling.

    p = char pointer to start of 8-integer block
    i = char offset (constant) into 8-integer block
    t = temporary int variable for reversing bytes
*/
#define REVERSE32(p,t, i) \
  t = p[0+i]; p[0+i] = p[3+i]; p[3+i] = t; \
  t = p[1+i]; p[1+i] = p[2+i]; p[2+i] = t


/**********************************************************************/
void
Reverse2ByteOrder(
    int nele,         /* specify number of 2-byte elements to reverse */
    void *pdata       /* specify and return byte reversed data */
)
/*----------------------------------------------------------------------
Reverse byte order in array of 2 byte words (inplace).
----------------------------------------------------------------------*/
{
  char *cp = pdata;
  int     t;

  /* end of unrolled loop */
  char   *e1 = (char *) (((INT16 *) pdata) + (nele & ~15));

  /* real end of array */
  char   *e2 = (char *) ((INT16 *) pdata + nele);

  /* 16 fold loop unrolling because REVERSE16 is a very small macro */
  for (; cp < e1; cp += 32) {
    REVERSE16(cp, t, 0);
    REVERSE16(cp, t, 2);
    REVERSE16(cp, t, 4);
    REVERSE16(cp, t, 6);
    REVERSE16(cp, t, 8);
    REVERSE16(cp, t, 10);
    REVERSE16(cp, t, 12);
    REVERSE16(cp, t, 14);
    REVERSE16(cp, t, 16);
    REVERSE16(cp, t, 18);
    REVERSE16(cp, t, 20);
    REVERSE16(cp, t, 22);
    REVERSE16(cp, t, 24);
    REVERSE16(cp, t, 26);
    REVERSE16(cp, t, 28);
    REVERSE16(cp, t, 30);
  }

  /* do remaining shorts as necessary */
  for (; cp < e2; cp += 2) {
    REVERSE16(cp, t, 0);
  }
}  /* Reverse2ByteOrder() */


/**********************************************************************/
void
Reverse4ByteOrder(
    int nele,    /* specify number of 4-byte elements to byte reverse */
    void *pdata  /* specify and return converted data */
)
/*----------------------------------------------------------------------
Reverse byte order in array of 4 byte words (inplace).
----------------------------------------------------------------------*/
{
  char *cp = pdata;
  int     t;

  /* end of unrolled loop */
  char   *e1 = (char *) (((INT32 *) pdata) + (nele & ~7));

  /* real end of array */
  char   *e2 = (char *) ((INT32 *) pdata + nele);

  /* 8 fold loop unrolling because REVERSE32 is a fairly small macro */
  for (; cp < e1; cp += 32) {
    REVERSE32(cp, t, 0);
    REVERSE32(cp, t, 4);
    REVERSE32(cp, t, 8);
    REVERSE32(cp, t, 12);
    REVERSE32(cp, t, 16);
    REVERSE32(cp, t, 20);
    REVERSE32(cp, t, 24);
    REVERSE32(cp, t, 28);
  }

  /* do remaining ints as necessary */
  for (; cp < e2; cp += 4) {
    REVERSE32(cp, t, 0);
  }
}  /* Reverse4ByteOrder() */
