/*
************************************************************************
*
*   Segment.c - spectrum segmentation
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/app/src/app/SCCS/s.Segment.c
*   SCCS identification       : 1.2
*
************************************************************************
*/

#include "segment.h"

static SegCheckCoordF CheckF;
static SegAddSpanF AddF;
static void *ClientData;

static void spanFill(int, int *, int, int);

static void
spanFind(int dim, int *coord, int left, int right)
{
  BOOL same;
  int i, k;

  coord[0] = left;
  (void) CheckF(coord, FALSE, ClientData);  /* load row */

  i = left;
  for (;;) {
    coord[0] = i;
    if (! CheckF(coord, TRUE, ClientData)) {
      i++;
      break;
    }
    i--;
  }

  same = TRUE;

  for (;;) {
    for (;;) {
      if (i > right)
	break;
      coord[0] = i;
      if (CheckF(coord, same, ClientData))
	break;
      same = TRUE;
      i++;
    }

    if (i > right)
      break;
    
    same = TRUE;
  
    k = i + 1;
    for (;;) {
      coord[0] = k;
      if (! CheckF(coord, same, ClientData)) {
	k--;
	break;
      }
      k++;
    }

    spanFill(dim, coord, i, k);
    same = FALSE;
  }
}

static void
spanFill(int dim, int *coord, int left, int right)
{
  int neighA[APP_MAX_DIM];
  int dom, i;

  AddF(coord, left, right, ClientData);

  for (dom = 1; dom < dim; dom++) {
    for (i = 1; i < dim; i++)
      neighA[i] = coord[i];

    neighA[dom] = coord[dom] - 1;
    spanFind(dim, neighA, left, right);

    neighA[dom] = coord[dom] + 1;
    spanFind(dim, neighA, left, right);
  }
}

void
SegFill(int dim, int *seedA,
    SegCheckCoordF checkF, SegAddSpanF addF, void *clientData)
{
  int seed0, left, right;

  CheckF = checkF;
  AddF = addF;
  ClientData = clientData;

  if (! CheckF(seedA, FALSE, ClientData))
    return;

  seed0 = seedA[0];

  left = seed0 - 1;
  for (;;) {
    seedA[0] = left;
    if (! CheckF(seedA, TRUE, ClientData)) {
      left++;
      break;
    }
    left--;
  }

  right = seed0 + 1;
  for (;;) {
    seedA[0] = right;
    if (! CheckF(seedA, TRUE, ClientData)) {
      right--;
      break;
    }
    right++;
  }

  seedA[0] = seed0;

  spanFill(dim, seedA, left, right);
}
