/*
************************************************************************
*
*   Peak.c - management of peak lists
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/10/08
*   Pathname of SCCS file     : /sgiext/autopsy/app/src/app/SCCS/s.Peak.c
*   SCCS identification       : 1.3
*
************************************************************************
*/

#include <app/peak.h>

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include <linlist.h>
#include "spec.h"
#include "conv.h"
#include "peak_info.h"
#include "shape.h"

static LINLIST PeakList = NULL;

AppPeakP
AppAddPeak(AppSpectrumP specP, AppPeakP peakP)
{
  PeakInfo infoS;

  if (PeakList == NULL)
    PeakList = ListOpen(sizeof(PeakInfo));

  peakP->dimensionNo = specP->dim;
  peakP->symmetricPeakP = NULL;

  infoS.d = *peakP;
  infoS.specP = specP;

  return ListInsertLast(PeakList, &infoS);
}

void
AppPeakApply(AppSpectrumP specP, AppPeakApplyF applyF, void *clientData)
{
  PeakInfo *infoP, *nextInfoP;

  infoP = ListFirst(PeakList);
  while (infoP != NULL) {
    nextInfoP = ListNext(PeakList, infoP);  /* infoP may be removed */
    if (infoP->specP == specP)
      applyF((AppPeakP) infoP, clientData);
    infoP = nextInfoP;
  }
}

void
AppPeakGetIntegral(AppPeakP peakP, float *integrP, float *errP)
{
  float prod, errProd, sum, errSum, err;
  int dom, i;

  /* integral is product of the integral of all line shapes,
     multiplied by the amplitude. */

  prod = peakP->amplitude;
  errProd = 0.0;

  for (dom = 0; dom < peakP->dimensionNo; dom++) {
    AppShapeCompleteLevel(peakP->shapePA[dom], peakP->integrationLevel);

    sum = 0.0;
    errSum = 0.0;
    for (i = 0; i < peakP->shapePA[dom]->valueNo; i++) {
      sum += peakP->shapePA[dom]->valueA[i];
      err = peakP->shapePA[dom]->errorA[i];
      errSum += err + err;
    }
    errSum = sqrt(errSum);

    AppShapeOriginal(peakP->shapePA[dom]);

    prod *= sum;
    errProd = sqrt(errProd * errProd + errSum * errSum + errProd * errSum);
  }

  errProd *= peakP->amplitude;

  *integrP = prod;
  *errP = errProd;
}

void
AppRemovePeak(AppPeakP peakP)
{
  int i;

  for (i = 0; i < peakP->dimensionNo; i++)
    AppShapeDestroy(peakP->shapePA[i]);

  ListRemove(PeakList, peakP);
}

LINLIST
PeakListGet(void)
{
  return PeakList;
}
