/*
************************************************************************
*
*   memory.h - I/O of spectra that are in memory already
*
*   Copyright (c) 1996
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 96/09/13
*   Pathname of SCCS file     : /sgiext/autopsy/app/include/specio/SCCS/s.memory.h
*   SCCS identification       : 1.2
*
************************************************************************
*/

#include <app/spec_access.h>

extern AppSpectrumP SpecIOMemoryOpen(void *dataA, int dim,
    int sizeA[], float offsA[], float swA[], AppDataType type);
/* Open spectrum in memory. dim is the number of dimensions, sizeA must
   contain the sizes in all dimensions, offsA and swA contain the
   parameters (offsets and sweep widths) used by AppConvertSpectrumUnit().
   type gives the data type. */

extern void SpecIOMemoryClose(AppSpectrumP specP);
/* Close a file opened with SpecIOOpenMemory(). */
